"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHumanizedDuration = exports.getFormattedDurationString = exports.ONE_YEAR = exports.ONE_SECOND = exports.ONE_MONTH = exports.ONE_MINUTE = exports.ONE_MILLISECOND_AS_NANOSECONDS = exports.ONE_HOUR = exports.ONE_DAY = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _empty_value = require("../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** one millisecond (as nanoseconds) */
const ONE_MILLISECOND_AS_NANOSECONDS = exports.ONE_MILLISECOND_AS_NANOSECONDS = 1000000;
const ONE_SECOND = exports.ONE_SECOND = 1000;
const ONE_MINUTE = exports.ONE_MINUTE = 60000;
const ONE_HOUR = exports.ONE_HOUR = 3600000;
const ONE_DAY = exports.ONE_DAY = 86400000; // ms
const ONE_MONTH = exports.ONE_MONTH = 2592000000; // ms
const ONE_YEAR = exports.ONE_YEAR = 31536000000; // ms

const milliseconds = duration => Number.isInteger(duration.milliseconds()) ? `${duration.milliseconds()}ms` : `${duration.milliseconds().toFixed(6)}ms`; // nanosecond precision
const seconds = duration => `${duration.seconds().toFixed()}s${duration.milliseconds() > 0 ? ` ${milliseconds(duration)}` : ''}`;
const minutes = duration => `${duration.minutes()}m ${seconds(duration)}`;
const hours = duration => `${duration.hours()}h ${minutes(duration)}`;
const days = duration => `${duration.days()}d ${hours(duration)}`;
const months = duration => `${duration.years() > 0 || duration.months() > 0 ? `${duration.months()}m ` : ''}${days(duration)}`;
const years = duration => `${duration.years() > 0 ? `${duration.years()}y ` : ''}${months(duration)}`;
const getFormattedDurationString = maybeDurationNanoseconds => {
  const totalNanoseconds = Number(maybeDurationNanoseconds);
  if (maybeDurationNanoseconds == null) {
    return (0, _empty_value.getEmptyValue)();
  }
  if (Number.isNaN(totalNanoseconds) || totalNanoseconds < 0) {
    return `${maybeDurationNanoseconds}`; // echo back the duration as a string
  }
  if (totalNanoseconds < ONE_MILLISECOND_AS_NANOSECONDS) {
    return `${totalNanoseconds}ns`; // display the raw nanoseconds
  }
  const duration = _moment.default.duration(totalNanoseconds / ONE_MILLISECOND_AS_NANOSECONDS);
  const totalMs = duration.asMilliseconds();
  if (totalMs < ONE_SECOND) {
    return milliseconds(duration);
  } else if (totalMs < ONE_MINUTE) {
    return seconds(duration);
  } else if (totalMs < ONE_HOUR) {
    return minutes(duration);
  } else if (totalMs < ONE_DAY) {
    return hours(duration);
  } else if (totalMs < ONE_MONTH) {
    return days(duration);
  } else if (totalMs < ONE_YEAR) {
    return months(duration);
  } else {
    return years(duration);
  }
};
exports.getFormattedDurationString = getFormattedDurationString;
const getHumanizedDuration = maybeDurationNanoseconds => {
  if (maybeDurationNanoseconds == null) {
    return i18n.NO_DURATION;
  }
  const totalNanoseconds = Number(maybeDurationNanoseconds);
  if (Number.isNaN(totalNanoseconds) || totalNanoseconds < 0) {
    return i18n.INVALID_DURATION;
  }
  if (totalNanoseconds === 0) {
    return i18n.ZERO_NANOSECONDS;
  } else if (totalNanoseconds === 1) {
    return i18n.A_NANOSECOND;
  } else if (totalNanoseconds < ONE_MILLISECOND_AS_NANOSECONDS) {
    return i18n.A_FEW_NANOSECONDS;
  } else if (totalNanoseconds === ONE_MILLISECOND_AS_NANOSECONDS) {
    return i18n.A_MILLISECOND;
  }
  const totalMs = totalNanoseconds / ONE_MILLISECOND_AS_NANOSECONDS;
  if (totalMs < ONE_SECOND) {
    return i18n.A_FEW_MILLISECONDS;
  } else if (totalMs === ONE_SECOND) {
    return i18n.A_SECOND;
  } else {
    return _moment.default.duration(totalMs).humanize();
  }
};
exports.getHumanizedDuration = getHumanizedDuration;