"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MoreContainer = exports.DEFAULT_MORE_MAX_HEIGHT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _context = require("../../timeline/context");
var _helpers = require("../../../../helpers");
var _helpers2 = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _model = require("../../../../sourcerer/store/model");
var _cell_actions = require("../../../../common/components/cell_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/field_renderers/more_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** The default max-height of the popover used to show "+n More" items (e.g. `+9 More`) */
const DEFAULT_MORE_MAX_HEIGHT = exports.DEFAULT_MORE_MAX_HEIGHT = '200px';
const MoreContainer = exports.MoreContainer = /*#__PURE__*/_react.default.memo(({
  fieldName,
  idPrefix,
  moreMaxHeight = DEFAULT_MORE_MAX_HEIGHT,
  overflowIndexStart,
  render,
  values,
  scopeId
}) => {
  const {
    timelineId
  } = (0, _react.useContext)(_context.TimelineContext);
  const defaultedScopeId = scopeId !== null && scopeId !== void 0 ? scopeId : timelineId;
  const sourcererScopeId = (0, _helpers.getSourcererScopeId)(defaultedScopeId !== null && defaultedScopeId !== void 0 ? defaultedScopeId : '');
  const moreItemsWithHoverActions = (0, _react.useMemo)(() => values.slice(overflowIndexStart).reduce((acc, value, index) => {
    const id = (0, _helpers2.escapeDataProviderId)(`${idPrefix}-${fieldName}-${value}-${index}`);
    if (typeof value === 'string' && fieldName != null) {
      acc.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value,
          field: fieldName
        },
        sourcererScopeId: sourcererScopeId !== null && sourcererScopeId !== void 0 ? sourcererScopeId : _model.SourcererScopeName.default,
        metadata: {
          scopeId: defaultedScopeId !== null && defaultedScopeId !== void 0 ? defaultedScopeId : undefined
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render ? render(value) : (0, _empty_value.defaultToEmptyTag)(value)))));
    }
    return acc;
  }, []), [values, overflowIndexStart, idPrefix, fieldName, sourcererScopeId, defaultedScopeId, render]);
  const moreContainerStyles = () => (0, _css.css)`
      max-height: ${moreMaxHeight};
      padding-right: 2px;
    `;
  const moreContainerClasses = (0, _classnames.default)(moreContainerStyles(), 'eui-yScroll');
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "more-container",
    className: moreContainerClasses,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": "overflow-items",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, moreItemsWithHoverActions));
});
MoreContainer.displayName = 'MoreContainer';