"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecuritySolutionLink = void 0;
var _navigation = require("../constants/navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Properties used in the Security Solution plugin to add links to the navigation.
 * The properties come from LinkItem (x-pack/solutions/security/plugins/security_solution/public/common/links/types.ts).
 *
 * If we want to control more from within the Threat Intelligence plugin, we can keep growing this interface.
 */

/**
 * Gets the threat intelligence properties of a TI page for navigation in the security solution.
 * @param threatIntelligencePage the name of the threat intelligence page.
 * @returns a {@link TILinkItem}
 */
const getSecuritySolutionLink = threatIntelligencePage => ({
  id: _navigation.threatIntelligencePages[threatIntelligencePage].id,
  title: _navigation.threatIntelligencePages[threatIntelligencePage].newNavigationName,
  path: _navigation.threatIntelligencePages[threatIntelligencePage].path,
  description: _navigation.threatIntelligencePages[threatIntelligencePage].description,
  globalSearchKeywords: _navigation.threatIntelligencePages[threatIntelligencePage].globalSearchKeywords
});
exports.getSecuritySolutionLink = getSecuritySolutionLink;