"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScreenReaderAnnouncements = exports.ScreenReaderAnnouncementsContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Context for triggering screen reader announcements.
 */
const ScreenReaderAnnouncementsContext = exports.ScreenReaderAnnouncementsContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Hook to access the screen reader announcements context.
 * @throws Error if used outside of ScreenReaderAnnouncementsProvider.
 */
const useScreenReaderAnnouncements = () => {
  const contextValue = (0, _react.useContext)(ScreenReaderAnnouncementsContext);
  if (!contextValue) {
    throw new Error('useScreenReaderAnnouncements must be used within a ScreenReaderAnnouncementsProvider');
  }
  return contextValue;
};
exports.useScreenReaderAnnouncements = useScreenReaderAnnouncements;