"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _empty_prompt = require("./empty_prompt");
var _fields_table = require("./fields_table");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/table_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Displays all the properties and values of an {@link Indicator} in table view,
 * using the {@link EuiInMemoryTable} from the @elastic/eui library.
 */
const IndicatorsFlyoutTable = ({
  indicator
}) => {
  const items = Object.keys(indicator.fields);
  return items.length === 0 ? /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_fields_table.IndicatorFieldsTable, {
    "data-test-subj": _test_ids.FLYOUT_TABLE_TEST_ID,
    fields: items,
    indicator: indicator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
};
exports.IndicatorsFlyoutTable = IndicatorsFlyoutTable;