"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorFieldsTable = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _field_value = require("../common/field_value");
var _unwrap_value = require("../../utils/unwrap_value");
var _cell_actions = require("../../../../../common/components/cell_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiTableSearchOptions = {
  box: {
    schema: true,
    incremental: true
  }
};
const IndicatorFieldsTable = ({
  fields,
  indicator,
  'data-test-subj': dataTestSubj,
  compressed
}) => {
  const smallFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const columns = (0, _react.useMemo)(() => [{
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.fieldsTable.fieldColumnLabel",
      defaultMessage: "Field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }),
    render: item => item.key,
    width: '30%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.fieldsTable.valueColumnLabel",
      defaultMessage: "Value",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }),
    render: item => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        field: item.key,
        value: item.value
      },
      mode: _cell_actions.CellActionsMode.HOVER_DOWN,
      triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
      indicator: indicator,
      field: item.key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    })),
    width: '70%'
  }], [indicator]);
  const items = (0, _react.useMemo)(() => {
    return fields.toSorted().reduce((acc, field) => {
      const value = (0, _unwrap_value.unwrapValue)(indicator, field);
      return [...acc, {
        key: field,
        value
      }];
    }, []);
  }, [fields, indicator]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    sorting: true,
    "data-test-subj": dataTestSubj,
    css: (0, _react2.css)`
        .euiTableRow {
          font-size: ${smallFontSize};
        }
      `,
    search: euiTableSearchOptions,
    compressed: compressed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  });
};
exports.IndicatorFieldsTable = IndicatorFieldsTable;