"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initComponent = exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _comment_children = require("./comment_children");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/cases/components/attachment_children.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Component lazy loaded when creating a new attachment type that will be registered
 * as an external reference.
 * The component is then shown in the Cases view.
 * It renders some text and a flyout.
 */
const initComponent = () => {
  // eslint-disable-next-line react/display-name
  return props => {
    const indicatorId = props.externalReferenceId;
    const metadata = props.externalReferenceMetadata;
    return /*#__PURE__*/_react.default.createElement(_comment_children.CommentChildren, {
      id: indicatorId,
      metadata: metadata,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 12
      }
    });
  };
};

// Note: This is for lazy loading
// eslint-disable-next-line import/no-default-export
exports.initComponent = initComponent;
var _default = exports.default = initComponent();