"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToNewCase = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_case_permission = require("../hooks/use_case_permission");
var _attachments = require("../utils/attachments");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/cases/components/add_to_new_case.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Leverages the cases plugin api to display a flyout to create a new case.
 * Once a case is created, an attachment is added to it and a confirmation snackbar
 * presents a link to view the case.
 *
 * This component renders an {@link EuiContextMenu}.
 *
 * @returns add to existing case for a context menu
 */
const AddToNewCase = ({
  indicator,
  onClick,
  'data-test-subj': dataTestSubj
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const createCaseFlyout = cases.hooks.useCasesAddToNewCaseFlyout();
  const id = indicator._id;
  const attachmentMetadata = (0, _attachments.generateAttachmentsMetadata)(indicator);
  const attachments = (0, _attachments.generateAttachmentsWithoutOwner)(id, attachmentMetadata);
  const menuItemClicked = () => {
    onClick();
    createCaseFlyout.open({
      attachments
    });
  };
  const disabled = (0, _use_case_permission.useCaseDisabled)(attachmentMetadata.indicatorName);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "attachmentsNewCase",
    onClick: () => menuItemClicked(),
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add to new case",
    id: "xpack.securitySolution.threatIntelligence.addToNewCase",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.AddToNewCase = AddToNewCase;