"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var _blocklist_form = require("../../../../management/pages/blocklist/view/components/blocklist_form");
var _artifact_flyout = require("../../../../management/components/artifact_list_page/components/artifact_flyout");
var _use_block_list_context = require("../../indicators/hooks/use_block_list_context");
var _translations = require("./translations");
var _services = require("../../../../management/pages/blocklist/services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/block_list/containers/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// texts to customize the flyout
const labels = {
  flyoutCreateTitle: _translations.ADD_TO_BLOCKLIST_FLYOUT_TITLE
};
/**
 * Component calling the block list flyout (retrieved from the SecuritySolution plugin via context).
 * This reuses a lot of components passed down via context from the Security Solution plugin:
 * - the flyout component: x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_list_page/components/artifact_flyout.tsx
 * - the form component: x-pack/solutions/security/plugins/security_solution/public/management/pages/blocklist/view/components/blocklist_form.tsx
 */
const BlockListFlyout = ({
  indicatorFileHash
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    setBlockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const exceptionListApiClient = _services.BlocklistsApiClient.getInstance(http);

  // prepopulate the for with the indicator file hash
  const entries = (0, _react.useMemo)(() => [{
    field: 'file.hash.*',
    operator: 'included',
    type: 'match_any',
    value: [indicatorFileHash]
  }], [indicatorFileHash]);

  // prepare the payload to pass to the form (and then sent to the blocklist endpoint)
  const item = (0, _react.useMemo)(() => ({
    description: '',
    entries,
    list_id: 'endpoint_blocklists',
    name: '',
    namespace_type: 'agnostic',
    os_types: ['windows'],
    tags: ['policy:all'],
    type: 'simple'
  }), [entries]);
  const clearBlockListIndicatorValue = (0, _react.useCallback)(() => setBlockListIndicatorValue(''), [setBlockListIndicatorValue]);
  const onSuccess = (0, _react.useCallback)(() => null, []);
  return /*#__PURE__*/_react.default.createElement(_artifact_flyout.ArtifactFlyout, {
    apiClient: exceptionListApiClient,
    labels: labels,
    item: item,
    FormComponent: _blocklist_form.BlockListForm,
    onClose: clearBlockListIndicatorValue,
    onSuccess: onSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.BlockListFlyout = BlockListFlyout;