"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
var _model = require("./model");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourcererReducer = exports.sourcererReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(_model.initialSourcererState).case(_actions.setSignalIndexName, (state, {
  signalIndexName
}) => ({
  ...state,
  signalIndexName
})).case(_actions.setDataViewLoading, (state, {
  id,
  loading
}) => ({
  ...state,
  ...(id === state.defaultDataView.id ? {
    defaultDataView: {
      ...state.defaultDataView,
      loading
    }
  } : {}),
  kibanaDataViews: state.kibanaDataViews.map(dv => dv.id === id ? {
    ...dv,
    loading
  } : dv)
})).case(_actions.setSourcererDataViews, (state, {
  defaultDataView,
  kibanaDataViews
}) => ({
  ...state,
  defaultDataView: {
    ...state.defaultDataView,
    ...defaultDataView
  },
  kibanaDataViews: kibanaDataViews.map(dataView => {
    var _state$kibanaDataView;
    return {
      ...((_state$kibanaDataView = state.kibanaDataViews.find(({
        id
      }) => id === dataView.id)) !== null && _state$kibanaDataView !== void 0 ? _state$kibanaDataView : _model.initDataView),
      ...dataView
    };
  })
})).case(_actions.setSourcererScopeLoading, (state, {
  id,
  loading
}) => ({
  ...state,
  sourcererScopes: {
    ...state.sourcererScopes,
    ...(id != null ? {
      [id]: {
        ...state.sourcererScopes[id],
        loading
      }
    } : {
      [_model.SourcererScopeName.default]: {
        ...state.sourcererScopes[_model.SourcererScopeName.default],
        loading
      },
      [_model.SourcererScopeName.detections]: {
        ...state.sourcererScopes[_model.SourcererScopeName.detections],
        loading
      },
      [_model.SourcererScopeName.timeline]: {
        ...state.sourcererScopes[_model.SourcererScopeName.timeline],
        loading
      }
    })
  }
})).case(_actions.setSelectedDataView, (state, payload) => {
  const {
    shouldValidateSelectedPatterns = true,
    ...patternsInfo
  } = payload;
  return {
    ...state,
    sourcererScopes: {
      ...state.sourcererScopes,
      ...(0, _helpers.validateSelectedPatterns)(state, patternsInfo, shouldValidateSelectedPatterns)
    }
  };
}).case(_actions.setDataView, (state, dataView) => ({
  ...state,
  ...(dataView.id === state.defaultDataView.id ? {
    defaultDataView: {
      ...state.defaultDataView,
      ...dataView
    }
  } : {}),
  kibanaDataViews: state.kibanaDataViews.map(dv => dv.id === dataView.id ? {
    ...dv,
    ...dataView
  } : dv)
})).build();