"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemporarySourcererComp = exports.TemporarySourcerer = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _update_default_data_view_modal = require("./update_default_data_view_modal");
var _types = require("../../../common/types");
var _timeline = require("../../../common/api/timeline");
var _store = require("../../timelines/store");
var _use_selector = require("../../common/hooks/use_selector");
var _defaults = require("../../timelines/store/defaults");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/temporary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const translations = {
  deprecated: {
    title: {
      [_timeline.TimelineTypeEnum.default]: i18n.CALL_OUT_DEPRECATED_TITLE,
      [_timeline.TimelineTypeEnum.template]: i18n.CALL_OUT_DEPRECATED_TEMPLATE_TITLE
    },
    update: i18n.UPDATE_INDEX_PATTERNS
  },
  missingPatterns: {
    title: {
      [_timeline.TimelineTypeEnum.default]: i18n.CALL_OUT_MISSING_PATTERNS_TITLE,
      [_timeline.TimelineTypeEnum.template]: i18n.CALL_OUT_MISSING_PATTERNS_TEMPLATE_TITLE
    },
    update: i18n.ADD_INDEX_PATTERN
  }
};
const TemporarySourcererComp = exports.TemporarySourcererComp = /*#__PURE__*/_react.default.memo(({
  activePatterns,
  indicesExist,
  isModified,
  onDismiss,
  onReset,
  onUpdate,
  selectedPatterns,
  missingPatterns
}) => {
  const trigger = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sourcerer-deprecated-update",
    fill: true,
    fullWidth: true,
    onClick: onUpdate,
    size: "s",
    disabled: !indicesExist,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, translations[isModified].update), [indicesExist, isModified, onUpdate]);
  const buttonWithTooltip = (0, _react.useMemo)(() => !indicesExist ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.NO_DATA,
    "data-test-subj": "sourcerer-tooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, trigger) : trigger, [indicesExist, trigger]);
  const deadPatterns = activePatterns && activePatterns.length > 0 ? selectedPatterns.filter(p => !activePatterns.includes(p)) : [];
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const timelineType = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, _types.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).timelineType;
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "sourcerer-deprecated-callout",
    iconType: "warning",
    size: "s",
    title: translations[isModified].title[timelineType],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, activePatterns && activePatterns.length > 0 ? /*#__PURE__*/_react.default.createElement(_utils.CurrentPatternsMessage, {
    timelineType: timelineType,
    activePatterns: activePatterns,
    deadPatterns: deadPatterns,
    selectedPatterns: selectedPatterns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_utils.BadCurrentPatternsMessage, {
    timelineType: timelineType,
    selectedPatterns: selectedPatterns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }), isModified === 'deprecated' && /*#__PURE__*/_react.default.createElement(_utils.DeprecatedMessage, {
    timelineType: timelineType,
    onReset: onReset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }), isModified === 'missingPatterns' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-missing-patterns-callout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.missingPatterns.callout",
    defaultMessage: "Security Data View is missing the following index patterns: {callout}",
    values: {
      callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 34
        }
      }, missingPatterns.join(', '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_utils.MissingPatternsMessage, {
    timelineType: timelineType,
    onReset: onReset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.ResetButton, {
    "aria-label": i18n.INDEX_PATTERNS_CLOSE,
    "data-test-subj": "sourcerer-deprecated-close",
    flush: "left",
    onClick: onDismiss,
    title: i18n.INDEX_PATTERNS_CLOSE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, i18n.INDEX_PATTERNS_CLOSE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, buttonWithTooltip)));
});
TemporarySourcererComp.displayName = 'TemporarySourcererComp';
const TemporarySourcerer = exports.TemporarySourcerer = /*#__PURE__*/_react.default.memo(({
  activePatterns,
  indicesExist,
  isModified,
  missingPatterns,
  onContinueWithoutUpdate,
  onDismiss,
  onReset,
  onUpdateStepOne,
  onUpdateStepTwo,
  selectedPatterns,
  isShowingUpdateModal,
  onDismissModal
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TemporarySourcererComp, {
  activePatterns: activePatterns,
  indicesExist: indicesExist,
  isModified: isModified,
  missingPatterns: missingPatterns,
  onDismiss: onDismiss,
  onReset: onReset,
  onUpdate: onUpdateStepOne,
  selectedPatterns: selectedPatterns,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 210,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_update_default_data_view_modal.UpdateDefaultDataViewModal, {
  isShowing: isShowingUpdateModal,
  missingPatterns: missingPatterns,
  onDismissModal: onDismissModal,
  onContinue: onContinueWithoutUpdate,
  onUpdate: onUpdateStepTwo,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 220,
    columnNumber: 7
  }
})));
TemporarySourcerer.displayName = 'TemporarySourcerer';