"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.raiseSuccessToast = exports.SuccessToastContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/service/notification/success_notification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const raiseSuccessToast = (migration, core) => {
  const toast = core.notifications.toasts.addSuccess({
    color: 'success',
    iconType: 'check',
    toastLifeTimeMs: 1000 * 60 * 30,
    // 30 minutes
    title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.polling.successTitle', {
      defaultMessage: 'Rules translation complete.'
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
      core: core,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(SuccessToastContent, {
      migration: migration,
      dismissHandler: () => core.notifications.toasts.remove(toast),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    })), core)
  });
};
exports.raiseSuccessToast = raiseSuccessToast;
const SuccessToastContent = ({
  migration,
  dismissHandler
}) => {
  const navigation = {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
    path: migration.id
  };
  const {
    navigateTo,
    getAppUrl
  } = (0, _securitySolutionNavigation.useNavigation)();
  const onClick = ev => {
    ev.preventDefault();
    navigateTo(navigation);
    dismissHandler();
  };
  const url = getAppUrl(navigation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rulesService.polling.successText",
    defaultMessage: "Migration \"{name}\" has finished. Results have been added to the translated rules page.",
    values: {
      name: migration.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    href: url,
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rulesService.polling.successLinkText', {
    defaultMessage: 'Go to translated rules'
  }))));
};
exports.SuccessToastContent = SuccessToastContent;