"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntegrationsColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _integrations_popover = require("../../../../detection_engine/common/components/related_integrations/integrations_popover");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table_columns/integrations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createIntegrationsColumn = ({
  getMigrationRuleData
}) => {
  return {
    field: 'elastic_rule.integration_ids',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      title: i18n.COLUMN_INTEGRATIONS,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.tableColumn.integrationsTooltip",
        defaultMessage: "{title} The AI migration process tries to infer integrations from the queries provided, but its possible that a match might not be present.",
        values: {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 36,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 37,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 38,
              columnNumber: 21
            }
          }, i18n.COLUMN_INTEGRATIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 39,
              columnNumber: 21
            }
          })))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }),
    render: (_, rule) => {
      const migrationRuleData = getMigrationRuleData(rule.id);
      if (migrationRuleData !== null && migrationRuleData !== void 0 && migrationRuleData.isIntegrationsLoading) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 16
          }
        });
      }
      const relatedIntegrations = migrationRuleData === null || migrationRuleData === void 0 ? void 0 : migrationRuleData.relatedIntegrations;
      if (relatedIntegrations == null || relatedIntegrations.length === 0) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_integrations_popover.IntegrationsPopover, {
        relatedIntegrations: relatedIntegrations,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 14
        }
      });
    },
    truncateText: true,
    width: '143px',
    align: 'center'
  };
};
exports.createIntegrationsColumn = createIntegrationsColumn;