"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationResultPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _chartsTheme = require("@kbn/charts-theme");
var _react2 = require("@emotion/react");
var _panel_text = require("../../../../common/components/panel_text");
var _utils = require("../../../common/utils");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _centered_loading_spinner = require("../../../../common/components/centered_loading_spinner");
var _links = require("../../../../common/components/links");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _upload_missing_panel = require("./upload_missing_panel");
var _last_error = require("../../../common/components/migration_panels/last_error");
var _migration_title = require("../../../common/components/migration_panels/migration_title");
var _total_execution_time = require("../../../common/components/total_execution_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/migration_status_panels/migration_result_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const headerStyle = (0, _react2.css)`
  &:hover {
    cursor: pointer;
    text-decoration: underline;
  }
`;
const useCompleteBadgeStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _react2.css)`
    background-color: ${isDarkMode ? euiTheme.colors.success : euiTheme.colors.backgroundBaseSuccess};
    color: ${isDarkMode ? euiTheme.colors.plainDark : euiTheme.colors.textSuccess};
    text-decoration: none;
  `;
};
const RuleMigrationResultPanel = exports.RuleMigrationResultPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  isCollapsed = false,
  onToggleCollapsed
}) => {
  var _migrationStats$last_, _migrationStats$last_2;
  const {
    data: translationStats,
    isLoading: isLoadingTranslationStats
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationStats.id);
  const completeBadgeStyles = useCompleteBadgeStyles();
  const toggleCollapsed = (0, _react.useCallback)(() => {
    onToggleCollapsed(!isCollapsed);
  }, [isCollapsed, onToggleCollapsed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    onClick: toggleCollapsed,
    css: headerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_migration_title.MigrationPanelTitle, {
    migrationStats: migrationStats,
    migrationType: "rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    subdued: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 21
    }
  }, i18n.RULE_MIGRATION_COMPLETE_DESCRIPTION((0, _moment.default)(migrationStats.created_at).format('MMMM Do YYYY, h:mm:ss a'), (0, _moment.default)(migrationStats.last_updated_at).fromNow())), ((_migrationStats$last_ = migrationStats.last_execution) === null || _migrationStats$last_ === void 0 ? void 0 : _migrationStats$last_.total_execution_time_ms) && /*#__PURE__*/_react.default.createElement(_total_execution_time.TotalExecutionTime, {
    migrationType: "rule",
    milliseconds: migrationStats.last_execution.total_execution_time_ms,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: completeBadgeStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, i18n.RULE_MIGRATION_COMPLETE_BADGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isCollapsed ? 'arrowDown' : 'arrowUp',
    onClick: toggleCollapsed,
    "aria-label": isCollapsed ? i18n.RULE_MIGRATION_EXPAND : i18n.RULE_MIGRATION_COLLAPSE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: migrationStats.id,
    initialIsOpen: !isCollapsed,
    forceState: isCollapsed ? 'closed' : 'open',
    arrowDisplay: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, ((_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_last_error.MigrationsLastError, {
    message: migrationStats.last_execution.error,
    migrationType: "rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _aiAssistantIcon.AssistantIcon,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 23
    }
  }, i18n.RULE_MIGRATION_SUMMARY_TITLE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "stretch",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 21
    }
  }, isLoadingTranslationStats ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 25
    }
  }) : translationStats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    css: {
      textAlign: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 31
    }
  }, i18n.RULE_MIGRATION_SUMMARY_CHART_TITLE)), /*#__PURE__*/_react.default.createElement(TranslationResultsChart, {
    translationStats: translationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 29
    }
  }), /*#__PURE__*/_react.default.createElement(TranslationResultsTable, {
    translationStats: translationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 29
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
    path: migrationStats.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 27
    }
  }, i18n.RULE_MIGRATION_VIEW_TRANSLATED_RULES_BUTTON)))))))), /*#__PURE__*/_react.default.createElement(_upload_missing_panel.RuleMigrationsUploadMissingPanel, {
    migrationStats: migrationStats,
    topSpacerSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))));
});
RuleMigrationResultPanel.displayName = 'MigrationResultPanel';
const TranslationResultsChart = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const translationResultColors = (0, _utils.useResultVisColors)();
  const data = [{
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL),
    value: translationStats.rules.success.result.full
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL),
    value: translationStats.rules.success.result.partial
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE),
    value: translationStats.rules.success.result.untranslatable
  }, {
    category: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    type: i18n.RULE_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.rules.failed
  }];
  const colors = [translationResultColors[_constants.MigrationTranslationResult.FULL], translationResultColors[_constants.MigrationTranslationResult.PARTIAL], translationResultColors[_constants.MigrationTranslationResult.UNTRANSLATABLE], translationResultColors.error];
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 130
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    baseTheme: baseTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "results",
    name: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
    data: data,
    xAccessor: "category",
    yAccessors: ['value'],
    splitSeriesAccessors: ['type'],
    stackAccessors: ['category'],
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    color: colors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }));
});
TranslationResultsChart.displayName = 'TranslationResultsChart';
const columns = [{
  field: 'title',
  name: i18n.RULE_MIGRATION_TABLE_COLUMN_STATUS,
  render: (title, {
    color
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    textSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `translationStatus-${title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, title, " "))
}, {
  field: 'value',
  name: i18n.RULE_MIGRATION_TABLE_COLUMN_RULES,
  align: 'right',
  render: (value, {
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": `translationStatusCount-${title}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 7
    }
  }, value)
}];
const TranslationResultsTable = /*#__PURE__*/_react.default.memo(({
  translationStats
}) => {
  const translationResultColors = (0, _utils.useResultVisColors)();
  const items = (0, _react.useMemo)(() => [{
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.FULL),
    value: translationStats.rules.success.result.full,
    color: translationResultColors[_constants.MigrationTranslationResult.FULL]
  }, {
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.PARTIAL),
    value: translationStats.rules.success.result.partial,
    color: translationResultColors[_constants.MigrationTranslationResult.PARTIAL]
  }, {
    title: (0, _utils.convertTranslationResultIntoText)(_constants.MigrationTranslationResult.UNTRANSLATABLE),
    value: translationStats.rules.success.result.untranslatable,
    color: translationResultColors[_constants.MigrationTranslationResult.UNTRANSLATABLE]
  }, {
    title: i18n.RULE_MIGRATION_TRANSLATION_FAILED,
    value: translationStats.rules.failed,
    color: translationResultColors.error
  }], [translationStats, translationResultColors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "translatedResultsTable",
    items: items,
    columns: columns,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 5
    }
  });
});
TranslationResultsTable.displayName = 'TranslationResultsTable';