"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsFileUpload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _migration_steps = require("../../../../../../../common/components/migration_steps");
var _file_upload_error = require("../../../../../../../common/translations/file_upload_error");
var _use_parse_file_input = require("../../../../../../../common/hooks/use_parse_file_input");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/upload_dashboards/sub_steps/dashboards_file_upload/dashboards_file_upload.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardsFileUpload = exports.DashboardsFileUpload = /*#__PURE__*/_react.default.memo(({
  migrationName,
  apiError,
  isLoading,
  isCreated,
  onDashboardsFileChanged,
  onFileUpload,
  createMigration
}) => {
  const [uploadedDashboards, setUploadedDashboards] = (0, _react.useState)([]);
  const filePickerRef = (0, _react.useRef)(null);
  const onFileParsed = (0, _react.useCallback)(content => {
    const dashboards = content.map(formatDashboardRow);
    setUploadedDashboards(dashboards);
    onFileUpload === null || onFileUpload === void 0 ? void 0 : onFileUpload(dashboards);
  }, [onFileUpload]);
  const createDashboards = (0, _react.useCallback)(() => {
    if (migrationName) {
      var _filePickerRef$curren;
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
      createMigration === null || createMigration === void 0 ? void 0 : createMigration(migrationName, uploadedDashboards);
    }
  }, [migrationName, createMigration, uploadedDashboards]);
  const {
    parseFile,
    isParsing,
    error: fileError
  } = (0, _use_parse_file_input.useParseFileInput)(onFileParsed);
  const onFileChange = (0, _react.useCallback)(files => {
    setUploadedDashboards([]);
    onDashboardsFileChanged === null || onDashboardsFileChanged === void 0 ? void 0 : onDashboardsFileChanged(files);
    parseFile(files);
  }, [parseFile, onDashboardsFileChanged]);
  const error = (0, _react.useMemo)(() => {
    if (apiError) {
      return apiError;
    }
    return fileError;
  }, [apiError, fileError]);
  const showLoader = isParsing || isLoading;
  const isDisabled = !migrationName || showLoader || isCreated;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: error != null,
    fullWidth: true,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    isInvalid: error != null,
    id: "dashboardsFilePicker",
    ref: filePickerRef,
    fullWidth: true,
    initialPromptText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    }, i18n.DASHBOARDS_DATA_INPUT_FILE_UPLOAD_PROMPT),
    accept: "application/json, application/x-ndjson",
    onChange: onFileChange,
    display: "large",
    "aria-label": "Upload dashboards file",
    isLoading: showLoader,
    disabled: isDisabled,
    "data-test-subj": "dashboardsFilePicker",
    "data-loading": isParsing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "dashboardsUploadFileButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_migration_steps.UploadFileButton, {
    onClick: createDashboards,
    isLoading: showLoader,
    disabled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  })))));
});
DashboardsFileUpload.displayName = 'DashboardsFileUpload';
const formatDashboardRow = row => {
  if (!(0, _lodash.isPlainObject)(row.result)) {
    throw new Error(_file_upload_error.FILE_UPLOAD_ERROR.NOT_OBJECT);
  }
  return row;
};