"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPLUNK_MACROS_COLUMNS = exports.SPLUNK_DASHBOARD_COLUMNS = exports.MACROS_SPLUNK_QUERY = exports.DASHBOARDS_SPLUNK_QUERY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPLUNK_DASHBOARD_COLUMNS = exports.SPLUNK_DASHBOARD_COLUMNS = ['id', 'label', 'title', 'description', 'version', 'eai:data', 'eai:acl.app', 'eai:acl.sharing', 'eai:acl.owner', 'updated'];
const DASHBOARDS_SPLUNK_QUERY = exports.DASHBOARDS_SPLUNK_QUERY = `| rest /servicesNS/-/-/data/ui/views
| search eai:acl.app != "SplunkEnterpriseSecuritySuite" author != "nobody" isDashboard=1
| table ${SPLUNK_DASHBOARD_COLUMNS.join(', ')}`;
const SPLUNK_MACROS_COLUMNS = exports.SPLUNK_MACROS_COLUMNS = ['title', 'definition'];
const MACROS_SPLUNK_QUERY = exports.MACROS_SPLUNK_QUERY = `| rest /servicesNS/-/-/admin/macros count=0
| table ${SPLUNK_MACROS_COLUMNS.join(', ')}`;