"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LookupsFileUpload = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ = require("../..");
var _file_upload_error = require("../../../../translations/file_upload_error");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/migration_steps/lookups/lookups_file_upload/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LookupsFileUpload = exports.LookupsFileUpload = /*#__PURE__*/_react.default.memo(({
  createResources,
  apiError,
  isLoading
}) => {
  const [lookupResources, setLookupResources] = (0, _react.useState)([]);
  const filePickerRef = (0, _react.useRef)(null);
  const createLookups = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
    createResources(lookupResources);
  }, [createResources, lookupResources]);
  const [isParsing, setIsParsing] = (0, _react.useState)(false);
  const [fileErrors, setErrors] = (0, _react.useState)([]);
  const addError = (0, _react.useCallback)(error => {
    setErrors(current => [...current, error]);
  }, []);
  const parseFile = (0, _react.useCallback)(async files => {
    setErrors([]);
    setLookupResources([]);
    if (!(files !== null && files !== void 0 && files.length)) {
      return;
    }
    const lookups = await Promise.all(Array.from(files).map(file => {
      return new Promise(resolve => {
        const reader = new FileReader();
        reader.onloadstart = () => setIsParsing(true);
        reader.onloadend = () => setIsParsing(false);
        reader.onload = function (e) {
          var _e$target;
          // We can safely cast to string since we call `readAsText` to load the file.
          const content = (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result;
          if (content == null) {
            addError(_file_upload_error.FILE_UPLOAD_ERROR.CAN_NOT_READ);
            return;
          }
          if (content === '' && e.loaded > 100000) {
            // V8-based browsers can't handle large files and return an empty string
            // instead of an error; see https://stackoverflow.com/a/61316641
            addError(_file_upload_error.FILE_UPLOAD_ERROR.TOO_LARGE_TO_PARSE);
            return;
          }
          const name = file.name.replace(/\.[^/.]+$/, '').trim();
          resolve({
            type: 'lookup',
            name,
            content
          });
        };
        const handleReaderError = function () {
          var _reader$error;
          const message = (_reader$error = reader.error) === null || _reader$error === void 0 ? void 0 : _reader$error.message;
          if (message) {
            addError(_file_upload_error.FILE_UPLOAD_ERROR.CAN_NOT_READ_WITH_REASON(message));
          } else {
            addError(_file_upload_error.FILE_UPLOAD_ERROR.CAN_NOT_READ);
          }
        };
        reader.onerror = handleReaderError;
        reader.onabort = handleReaderError;
        reader.readAsText(file);
      });
    })).catch(e => {
      addError(e.message);
      return [];
    });
    // Set the loaded lookups to the state
    setLookupResources(current => [...current, ...lookups]);
  }, [addError]);
  const errors = (0, _react.useMemo)(() => {
    if (apiError) {
      return [apiError];
    }
    return fileErrors;
  }, [apiError, fileErrors]);
  const showLoader = isParsing || isLoading;
  const isButtonDisabled = showLoader || lookupResources.length === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: errors.map(error => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }, error)),
    isInvalid: errors.length > 0,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    isInvalid: errors.length > 0,
    id: "lookupsFilePicker",
    ref: filePickerRef,
    fullWidth: true,
    initialPromptText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, i18n.LOOKUPS_DATA_INPUT_FILE_UPLOAD_PROMPT),
    accept: "application/text",
    onChange: parseFile,
    multiple: true,
    display: "large",
    "aria-label": "Upload lookups files",
    isLoading: showLoader,
    disabled: showLoader,
    "data-test-subj": "lookupsFilePicker",
    "data-loading": isParsing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_.UploadFileButton, {
    onClick: createLookups,
    isLoading: showLoader,
    disabled: isButtonDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  })))));
});
LookupsFileUpload.displayName = 'LookupsFileUpload';