"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationPanelTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _panel_text = require("../../../../common/components/panel_text");
var _constants = require("../../../../../common/siem_migrations/constants");
var _use_delete_migrations = require("../../hooks/use_delete_migrations");
var _use_update_siem_migration = require("../../hooks/use_update_siem_migration");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_is_open_state = require("../../../../common/hooks/use_is_open_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/migration_panels/migration_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Generic MigrationTitle component for SIEM migrations (rules & dashboards)
 * Wraps inline rename + delete actions. Preserves existing data-test-subj values used by rule panels.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MigrationPanelTitle = exports.MigrationPanelTitle = /*#__PURE__*/_react.default.memo(function MigrationPanelTitle({
  migrationStats,
  migrationType
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [name, setName] = (0, _react.useState)(migrationStats.name);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const {
    isOpen: isPopoverOpen,
    toggle: togglePopover,
    close: closePopover
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const {
    isOpen: isDeleteModalOpen,
    open: openDeleteModal,
    close: closeDeleteModal
  } = (0, _use_is_open_state.useIsOpenState)(false);
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onRenameError = (0, _react.useCallback)(() => {
    setName(migrationStats.name); // revert visual name; toast handled in hook
  }, [migrationStats.name]);
  const {
    mutate: deleteMigration,
    isLoading: isDeleting
  } = (0, _use_delete_migrations.useDeleteMigration)(migrationType);
  const {
    mutate: updateMigration,
    isLoading: isUpdating
  } = (0, _use_update_siem_migration.useUpdateSiemMigration)(migrationType, {
    onError: onRenameError
  });
  const isDeletable = (0, _react.useMemo)(() => migrationStats.status !== _constants.SiemMigrationTaskStatus.RUNNING, [migrationStats.status]);
  const showRename = (0, _react.useCallback)(() => {
    closePopover();
    setIsEditing(true);
  }, [closePopover]);
  const showDelete = (0, _react.useCallback)(() => {
    closePopover();
    openDeleteModal();
  }, [closePopover, openDeleteModal]);
  const cancelEdit = (0, _react.useCallback)(() => setIsEditing(false), []);
  const saveName = (0, _react.useCallback)(value => {
    setName(value);
    updateMigration({
      migrationId: migrationStats.id,
      body: {
        name: value
      }
    });
    setIsEditing(false);
  }, [migrationStats.id, updateMigration]);
  const confirmDelete = (0, _react.useCallback)(() => {
    deleteMigration(migrationStats.id);
    closeDeleteModal();
  }, [deleteMigration, migrationStats.id, closeDeleteModal]);
  const stopPropagation = (0, _react.useCallback)(e => {
    e.stopPropagation(); // prevent click events from bubbling up and toggle the collapsible panel
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    "data-test-subj": "migrationPanelTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: stopPropagation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditText, {
    defaultValue: name,
    size: "s",
    inputAriaLabel: "Migration name",
    onCancel: cancelEdit,
    onSave: saveName,
    startWithEditOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    size: "s",
    semiBold: true,
    "data-test-subj": "migrationPanelTitleName",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onClick: stopPropagation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesVertical",
      onClick: togglePopover,
      "aria-label": i18n.OPEN_MIGRATION_OPTIONS_BUTTON,
      "data-test-subj": "openMigrationOptionsButton",
      isLoading: isUpdating || isDeleting,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 17
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "pencil",
    onClick: showRename,
    "data-test-subj": "renameMigrationItem",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  }, i18n.RENAME_MIGRATION_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "trash",
    onClick: showDelete,
    disabled: !isDeletable,
    css: {
      color: isDeletable ? euiTheme.colors.danger : undefined
    },
    "data-test-subj": "deleteMigrationItem",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isDeletable ? undefined : i18n.NOT_DELETABLE_MIGRATION_TEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 21
    }
  }, i18n.DELETE_BUTTON_TEXT))))), isDeleteModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: i18n.DELETE_MIGRATION_TITLE,
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: closeDeleteModal,
    onConfirm: confirmDelete,
    confirmButtonText: i18n.DELETE_MIGRATION_TEXT,
    cancelButtonText: i18n.CANCEL_DELETE_MIGRATION_TEXT,
    buttonColor: "danger",
    isLoading: isDeleting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }, i18n.DELETE_MIGRATION_DESCRIPTION)))));
});