"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolverPluginSetup = resolverPluginSetup;
var _reactRedux = require("react-redux");
var _store = require("./store");
var _resolver_without_providers = require("./view/resolver_without_providers");
var _no_ancestors_two_children_with_related_events_on_origin = require("./data_access_layer/mocks/no_ancestors_two_children_with_related_events_on_origin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @kbn/imports/no_boundary_crossing

/**
 * These exports are used by the plugin 'resolverTest' defined in x-pack's plugin_functional suite.
 */

/**
 * Provide access to Resolver APIs.
 */
function resolverPluginSetup() {
  return {
    Provider: _reactRedux.Provider,
    storeFactory: _store.resolverStoreFactory,
    ResolverWithoutProviders: _resolver_without_providers.ResolverWithoutProviders,
    mocks: {
      dataAccessLayer: {
        noAncestorsTwoChildrenWithRelatedEventsOnOrigin: _no_ancestors_two_children_with_related_events_on_origin.noAncestorsTwoChildrenWithRelatedEventsOnOrigin
      }
    }
  };
}