"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueMetrics = exports.getTimeSavedHours = exports.getTimeRangeAsDays = exports.getCostSavings = exports.formatThousands = exports.formatPercent = exports.formatDollars = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Define AlertData type if not already imported

const getValueMetrics = ({
  analystHourlyRate,
  attackDiscoveryCount,
  totalAlerts,
  escalatedAlertsCount,
  minutesPerAlert
}) => ({
  attackDiscoveryCount,
  filteredAlerts: totalAlerts - escalatedAlertsCount,
  filteredAlertsPerc: totalAlerts > 0 ? (totalAlerts - escalatedAlertsCount) / totalAlerts * 100 : 0,
  escalatedAlertsPerc: totalAlerts > 0 ? escalatedAlertsCount / totalAlerts * 100 : 0,
  hoursSaved: getTimeSavedHours(totalAlerts, minutesPerAlert),
  totalAlerts,
  costSavings: getCostSavings({
    alerts: totalAlerts,
    analystHourlyRate,
    minutesPerAlert
  })
});
exports.getValueMetrics = getValueMetrics;
const getTimeSavedHours = (alerts, minutesPerAlert) => {
  const totalMinutesSaved = alerts * minutesPerAlert;
  return totalMinutesSaved / 60;
};
exports.getTimeSavedHours = getTimeSavedHours;
const getCostSavings = ({
  alerts,
  minutesPerAlert,
  analystHourlyRate
}) => {
  const hoursSaved = getTimeSavedHours(alerts, minutesPerAlert);
  return hoursSaved * analystHourlyRate;
};
exports.getCostSavings = getCostSavings;
const formatDollars = value => (0, _eui.formatNumber)(roundTo(value, 2), {
  format: '$0,0',
  // e.g., $1,234,567
  nil: '-',
  round: true
});
exports.formatDollars = formatDollars;
const formatThousands = value => (0, _eui.formatNumber)(roundTo(value, 0), {
  format: '0,0'
});
exports.formatThousands = formatThousands;
const formatPercent = value => `${(0, _eui.formatNumber)(roundTo(value, 2), {
  format: '0.00'
})}%`;
exports.formatPercent = formatPercent;
const getTimeRangeAsDays = ({
  from,
  to
}) => {
  const duration = _moment.default.duration((0, _moment.default)(to).diff((0, _moment.default)(from)));
  const days = duration.asDays();
  return days < 1 ? `${roundTo(days, 2)}` : `${Math.round(days)}`;
};
exports.getTimeRangeAsDays = getTimeRangeAsDays;
function roundTo(value, decimals) {
  const factor = 10 ** decimals;
  return Math.round(value * factor) / factor;
}