"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CostSavingsTrend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../../common/components/visualization_actions/types");
var _model = require("../../../sourcerer/store/model");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _cost_savings_trend_area = require("../../../common/components/visualization_actions/lens_attributes/ai/cost_savings_trend_area");
var _cost_savings_key_insight = require("./cost_savings_key_insight");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/cost_savings_trend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = 'CostSavingsTrendQuery';

/**
 * Renders a Lens embeddable area chart visualization showing the estimated cost savings trend
 * over time, based on the number of AI filtered alerts, minutes saved per alert, and analyst hourly rate
 * for a given time range.
 */

const CostSavingsTrendComponent = ({
  minutesPerAlert,
  analystHourlyRate,
  isLoading,
  from,
  to
}) => {
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const getLensAttributes = (0, _react.useCallback)(args => (0, _cost_savings_trend_area.getCostSavingsTrendAreaLensAttributes)({
    ...args,
    minutesPerAlert,
    analystHourlyRate
  }), [analystHourlyRate, minutesPerAlert]);
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const [lensResponse, setLensResponse] = (0, _react.useState)(null);
  const handleEmbeddableLoad = (0, _react.useCallback)(data => {
    if (data !== null && data !== void 0 && data.tables) {
      setLensResponse(data.tables);
    }
  }, []);
  (0, _react.useEffect)(() => {
    // when timerange changes, reset lens response
    setLensResponse(null);
  }, [timerange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: ${size.base} ${size.xl};
        .euiPanel,
        .embPanel,
        .echMetric,
        .echChartBackground,
        .embPanel__hoverActions > span {
          background-color: rgb(0, 0, 0, 0) !important;
        }
      `,
    "data-test-subj": "cost-savings-trend-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, i18n.COST_SAVINGS_TREND)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    css: (0, _react2.css)`
          gap: 48px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-area-chart",
    getLensAttributes: getLensAttributes,
    timerange: timerange,
    onLoad: handleEmbeddableLoad,
    id: `${ID}-area-embeddable`,
    height: 300,
    inspectTitle: i18n.COST_SAVINGS_TREND,
    scopeId: _model.SourcererScopeName.detections,
    withActions: [_types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.inspect],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            max-width: ${isSmall ? 'auto' : '600px'};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cost_savings_key_insight.CostSavingsKeyInsight, {
    isLoading: isLoading,
    lensResponse: lensResponse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }))));
};
const CostSavingsTrend = exports.CostSavingsTrend = /*#__PURE__*/_react.default.memo(CostSavingsTrendComponent);