"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataQuality = void 0;
var _common = require("@kbn/cases-plugin/common");
var _ecsDataQualityDashboard = require("@kbn/ecs-data-quality-dashboard");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_assistant_availability = require("../../assistant/use_assistant_availability");
var _types = require("../../app/types");
var _common2 = require("../../common/components/charts/common");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _local_storage = require("../../common/components/local_storage");
var _page_wrapper = require("../../common/components/page_wrapper");
var _constants = require("../../../common/constants");
var _containers = require("../../sourcerer/containers");
var _kibana = require("../../common/lib/kibana");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var i18n = _interopRequireWildcard(require("./translations"));
var _telemetry = require("../../common/lib/telemetry");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/pages/data_quality.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOCAL_STORAGE_KEY = 'dataQualityDashboardLastChecked';
const DEFAULT_START_TIME = 'now-7d';
const DEFAULT_END_TIME = 'now';
const DataQualityComponent = () => {
  var _dataView$matchedIndi;
  const {
    isAssistantEnabled
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const httpFetch = _kibana.KibanaServices.get().http.fetch;
  const {
    baseTheme,
    theme
  } = (0, _common2.useThemes)();
  const toasts = (0, _kibana.useToasts)();
  const [defaultBytesFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_BYTES_FORMAT);
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)();
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const indicesExist = newDataViewPickerEnabled ? !!(dataView !== null && dataView !== void 0 && (_dataView$matchedIndi = dataView.matchedIndices) !== null && _dataView$matchedIndi !== void 0 && _dataView$matchedIndi.length) : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const isSourcererLoading = newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading;
  const {
    signalIndexName,
    loading: isSignalIndexNameLoading
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    configSettings,
    cases,
    telemetry
  } = (0, _kibana.useKibana)().services;
  const isILMAvailable = configSettings.ILMEnabled;
  const [startDate, setStartTime] = (0, _react.useState)();
  const [endDate, setEndTime] = (0, _react.useState)();
  const onTimeChange = ({
    start,
    end,
    isInvalid
  }) => {
    if (isInvalid) {
      return;
    }
    setStartTime(start);
    setEndTime(end);
  };
  (0, _react.useEffect)(() => {
    if (!isILMAvailable) {
      setStartTime(DEFAULT_START_TIME);
      setEndTime(DEFAULT_END_TIME);
    }
  }, [isILMAvailable]);
  const alertsAndSelectedPatterns = (0, _react.useMemo)(() => signalIndexName != null ? [signalIndexName, ...selectedPatterns] : [...selectedPatterns], [selectedPatterns, signalIndexName]);
  const subtitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, _ecsDataQualityDashboard.DATA_QUALITY_SUBTITLE), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: _ecsDataQualityDashboard.ECS_REFERENCE_URL,
    rel: "noopener noreferrer",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, i18n.ELASTIC_COMMON_SCHEMA)), []);
  const [lastChecked, setLastChecked] = (0, _local_storage.useLocalStorage)({
    defaultValue: '',
    key: LOCAL_STORAGE_KEY
  });
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const canUserCreateAndReadCases = (0, _react.useCallback)(() => userCasesPermissions.createComment && userCasesPermissions.read, [userCasesPermissions.createComment, userCasesPermissions.read]);
  const createCaseFlyout = cases.hooks.useCasesAddToNewCaseFlyout({
    toastContent: i18n.ADD_TO_CASE_SUCCESS
  });
  const openCreateCaseFlyout = (0, _react.useCallback)(({
    comments,
    headerContent
  }) => {
    const attachments = comments.map(x => ({
      comment: x,
      type: _common.AttachmentType.user
    }));
    createCaseFlyout.open({
      attachments,
      headerContent
    });
  }, [createCaseFlyout]);
  const reportDataQualityIndexChecked = (0, _react.useCallback)(params => {
    telemetry.reportEvent(_telemetry.DataQualityEventTypes.DataQualityIndexChecked, params);
  }, [telemetry]);
  const reportDataQualityCheckAllCompleted = (0, _react.useCallback)(params => {
    telemetry.reportEvent(_telemetry.DataQualityEventTypes.DataQualityCheckAllCompleted, params);
  }, [telemetry]);
  if (isSourcererLoading || isSignalIndexNameLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": "ecsDataQualityDashboardLoader",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 12
      }
    });
  }
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "ecsDataQualityDashboardPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: subtitle,
    title: i18n.DATA_QUALITY_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, !isILMAvailable && startDate && endDate && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.DATE_PICKER_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: startDate,
    end: endDate,
    onTimeChange: onTimeChange,
    showUpdateButton: false,
    isDisabled: true,
    "data-test-subj": "dataQualityDatePicker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_ecsDataQualityDashboard.DataQualityPanel, {
    baseTheme: baseTheme,
    canUserCreateAndReadCases: canUserCreateAndReadCases,
    defaultBytesFormat: defaultBytesFormat,
    defaultNumberFormat: defaultNumberFormat,
    endDate: endDate,
    reportDataQualityCheckAllCompleted: reportDataQualityCheckAllCompleted,
    reportDataQualityIndexChecked: reportDataQualityIndexChecked,
    httpFetch: httpFetch,
    isAssistantEnabled: isAssistantEnabled,
    isILMAvailable: isILMAvailable,
    lastChecked: lastChecked,
    openCreateCaseFlyout: openCreateCaseFlyout,
    patterns: alertsAndSelectedPatterns,
    setLastChecked: setLastChecked,
    startDate: startDate,
    theme: theme,
    toasts: toasts,
    defaultStartTime: DEFAULT_START_TIME,
    defaultEndTime: DEFAULT_END_TIME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.dataQuality,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }));
};
DataQualityComponent.displayName = 'DataQualityComponent';
const DataQuality = exports.DataQuality = /*#__PURE__*/_react.default.memo(DataQualityComponent);