"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/constants");
var _filters = require("../recent_timelines/filters");
var _recent_timelines = require("../recent_timelines");
var _news_feed = require("../../../common/components/news_feed");
var _user_privileges = require("../../../common/components/user_privileges");
var _sidebar_header = require("../../../common/components/sidebar_header");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _recent_cases = require("../recent_cases");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/sidebar/sidebar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SidebarSpacerComponent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xxl",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 5
  }
}));
SidebarSpacerComponent.displayName = 'SidebarSpacerComponent';
const Sidebar = exports.Sidebar = /*#__PURE__*/_react.default.memo(({
  recentTimelinesFilterBy,
  setRecentTimelinesFilterBy
}) => {
  const {
    cases
  } = (0, _kibana_react.useKibana)().services;
  const {
    timelinePrivileges: {
      read: canSeeTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const recentTimelinesFilters = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_filters.Filters, {
    filterBy: recentTimelinesFilterBy,
    setFilterBy: setRecentTimelinesFilterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), [recentTimelinesFilterBy, setRecentTimelinesFilterBy]);

  // only render the recently created cases view if the user has at least read permissions
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const hasCasesReadPermissions = userCasesPermissions.read;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, hasCasesReadPermissions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_recent_cases.RecentCases, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })), canSeeTimelines && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "recent-timelines-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
    title: i18n.RECENT_TIMELINES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, recentTimelinesFilters), /*#__PURE__*/_react.default.createElement(_recent_timelines.StatefulRecentTimelines, {
    filterBy: recentTimelinesFilterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_news_feed.StatefulNewsFeed, {
    enableNewsFeedSetting: _constants.ENABLE_NEWS_FEED_SETTING,
    newsFeedSetting: _constants.NEWS_FEED_URL_SETTING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })));
});
Sidebar.displayName = 'Sidebar';