"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CtiEnabledModuleComponent = exports.CtiEnabledModule = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_ti_data_sources = require("../../containers/overview_cti_links/use_ti_data_sources");
var _overview_cti_links = require("../../containers/overview_cti_links");
var _threat_intel_panel_view = require("./threat_intel_panel_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/overview_cti_links/cti_enabled_module.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CtiEnabledModuleComponent = props => {
  const {
    to,
    from,
    allTiDataSources,
    setQuery,
    deleteQuery
  } = props;
  const {
    tiDataSources,
    totalCount
  } = (0, _use_ti_data_sources.useTiDataSources)({
    to,
    from,
    allTiDataSources,
    setQuery,
    deleteQuery
  });
  const {
    listItems
  } = (0, _overview_cti_links.useCtiDashboardLinks)({
    tiDataSources
  });
  return /*#__PURE__*/_react.default.createElement(_threat_intel_panel_view.ThreatIntelPanelView, {
    listItems: listItems,
    totalCount: totalCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 10
    }
  });
};
exports.CtiEnabledModuleComponent = CtiEnabledModuleComponent;
const CtiEnabledModule = exports.CtiEnabledModule = /*#__PURE__*/_react.default.memo(CtiEnabledModuleComponent);
CtiEnabledModule.displayName = 'CtiEnabledModule';