"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsByStatus = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _types = require("../../../../../common/types");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _donutchart = require("../../../../common/components/charts/donutchart");
var _constants = require("../../../../../common/constants");
var _header_section = require("../../../../common/components/header_section");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _use_alerts_by_status = require("./use_alerts_by_status");
var _translations = require("../translations");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _translations2 = require("../../../pages/translations");
var _formatted_number = require("../../../../common/components/formatted_number");
var _user_privileges = require("../../../../common/components/user_privileges");
var _chart_label = require("./chart_label");
var _legend = require("../../../../common/components/charts/legend");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _links = require("../../../../common/components/links");
var _use_navigate_to_timeline = require("../hooks/use_navigate_to_timeline");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_alerts_by_status_visualization_data = require("./use_alerts_by_status_visualization_data");
var _types2 = require("./types");
var _model = require("../../../../sourcerer/store/model");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _alerts_by_status_donut = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_by_status_donut");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/alerts_by_status/alerts_by_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  padding: 0 4px;
`;
const StyledLegendFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  padding-left: 32px;
  padding-top: 45px;
`;
const ChartSize = 120;
const getChartConfigs = euiTheme => {
  const palette = (0, _risk_color_palette.getRiskSeverityColors)(euiTheme);
  return [{
    key: 'critical',
    label: _translations.STATUS_CRITICAL_LABEL,
    color: palette.critical
  }, {
    key: 'high',
    label: _translations.STATUS_HIGH_LABEL,
    color: palette.high
  }, {
    key: 'medium',
    label: _translations.STATUS_MEDIUM_LABEL,
    color: palette.medium
  }, {
    key: 'low',
    label: _translations.STATUS_LOW_LABEL,
    color: palette.low
  }].map(config => ({
    ...config,
    field: _ruleDataUtils.ALERT_SEVERITY,
    value: config.label
  }));
};
const eventKindSignalFilter = {
  field: 'event.kind',
  value: 'signal'
};
const openDonutOptions = {
  status: 'open'
};
const acknowledgedDonutOptions = {
  status: 'acknowledged'
};
const closedDonutOptions = {
  status: 'closed'
};
const AlertsByStatus = ({
  additionalFilters,
  applyGlobalQueriesAndFilters = true,
  signalIndexName,
  entityFilter
}) => {
  var _donutData$open$total, _donutData$open, _donutData$acknowledg, _donutData$acknowledg2, _donutData$closed$tot, _donutData$closed, _donutData$open2, _donutData$acknowledg3, _donutData$closed2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID);
  const {
    openTimelineWithFilters
  } = (0, _use_navigate_to_timeline.useNavigateToTimeline)();
  const navigateToAlerts = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    timelinePrivileges: {
      read: canAccessTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    onClick: goToAlerts,
    href
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _constants.SecurityPageName.alerts
  });
  const isDonutChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('donutChartEmbeddablesEnabled');
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const isLargerBreakpoint = (0, _eui.useIsWithinMinBreakpoint)('xl');
  const isSmallBreakpoint = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const donutHeight = isSmallBreakpoint || isLargerBreakpoint ? 120 : 90;
  const detailsButtonOptions = (0, _react.useMemo)(() => ({
    name: canAccessTimelines && entityFilter ? _translations.INVESTIGATE_IN_TIMELINE : _translations2.VIEW_ALERTS,
    href: canAccessTimelines && entityFilter ? undefined : href,
    onClick: canAccessTimelines && entityFilter ? async () => {
      await openTimelineWithFilters([[entityFilter, eventKindSignalFilter]]);
    } : goToAlerts
  }), [entityFilter, href, goToAlerts, openTimelineWithFilters, canAccessTimelines]);
  const {
    items: donutData,
    isLoading: loading,
    updatedAt
  } = (0, _use_alerts_by_status.useAlertsByStatus)({
    additionalFilters,
    entityFilter,
    signalIndexName,
    skip: !toggleStatus || isDonutChartEmbeddablesEnabled,
    queryId: _types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID,
    to,
    from
  });
  const legendItems = (0, _react.useMemo)(() => getChartConfigs(euiTheme), [euiTheme]);
  const navigateToAlertsWithStatus = (0, _react.useCallback)((status, level) => navigateToAlerts([{
    title: _translations.OPEN_IN_ALERTS_TITLE_STATUS,
    selectedOptions: [status],
    fieldName: _ruleDataUtils.ALERT_WORKFLOW_STATUS
  }, ...(level ? [{
    title: _translations.OPEN_IN_ALERTS_TITLE_SEVERITY,
    selectedOptions: [level],
    fieldName: _ruleDataUtils.ALERT_SEVERITY
  }] : []), ...(entityFilter ? [{
    selectedOptions: [entityFilter.value],
    fieldName: entityFilter.field
  }] : [])]), [entityFilter, navigateToAlerts]);
  const navigateToAlertsWithStatusOpen = (0, _react.useCallback)(level => navigateToAlertsWithStatus(_types.FILTER_OPEN, level === null || level === void 0 ? void 0 : level.toLocaleLowerCase()), [navigateToAlertsWithStatus]);
  const navigateToAlertsWithStatusAcknowledged = (0, _react.useCallback)(level => navigateToAlertsWithStatus(_types.FILTER_ACKNOWLEDGED, level === null || level === void 0 ? void 0 : level.toLocaleLowerCase()), [navigateToAlertsWithStatus]);
  const navigateToAlertsWithStatusClosed = (0, _react.useCallback)(level => navigateToAlertsWithStatus(_types.FILTER_CLOSED, level === null || level === void 0 ? void 0 : level.toLocaleLowerCase()), [navigateToAlertsWithStatus]);
  const openCount = (_donutData$open$total = donutData === null || donutData === void 0 ? void 0 : (_donutData$open = donutData.open) === null || _donutData$open === void 0 ? void 0 : _donutData$open.total) !== null && _donutData$open$total !== void 0 ? _donutData$open$total : 0;
  const acknowledgedCount = (_donutData$acknowledg = donutData === null || donutData === void 0 ? void 0 : (_donutData$acknowledg2 = donutData.acknowledged) === null || _donutData$acknowledg2 === void 0 ? void 0 : _donutData$acknowledg2.total) !== null && _donutData$acknowledg !== void 0 ? _donutData$acknowledg : 0;
  const closedCount = (_donutData$closed$tot = donutData === null || donutData === void 0 ? void 0 : (_donutData$closed = donutData.closed) === null || _donutData$closed === void 0 ? void 0 : _donutData$closed.total) !== null && _donutData$closed$tot !== void 0 ? _donutData$closed$tot : 0;
  const totalAlerts = loading || donutData == null ? 0 : openCount + acknowledgedCount + closedCount;
  const {
    total: visualizationTotalAlerts
  } = (0, _use_alerts_by_status_visualization_data.useAlertsByStatusVisualizationData)();
  const totalAlertsCount = isDonutChartEmbeddablesEnabled ? visualizationTotalAlerts : totalAlerts;
  const fillColor = (0, _react.useCallback)(dataName => {
    var _legendItems$find$col, _legendItems$find;
    return (_legendItems$find$col = (_legendItems$find = legendItems.find(({
      value
    }) => value === dataName)) === null || _legendItems$find === void 0 ? void 0 : _legendItems$find.color) !== null && _legendItems$find$col !== void 0 ? _legendItems$find$col : euiTheme.colors.textSubdued;
  }, [euiTheme.colors.textSubdued, legendItems]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": `${_types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-panel`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "initialLoadingPanelMatrixOverTime",
    size: "xs",
    position: "absolute",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: _types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID,
    title: entityFilter ? _translations.ALERTS_BY_SEVERITY_TEXT : _translations.ALERTS_TEXT,
    titleSize: "m",
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      isUpdating: loading,
      updatedAt: updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 23
      }
    }),
    inspectMultiple: true,
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    showInspectButton: !isDonutChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    "data-test-subj": "view-details-button",
    onClick: detailsButtonOptions.onClick,
    href: detailsButtonOptions.href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 17
    }
  }, detailsButtonOptions.name)))), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isDonutChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textCenter",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 19
    }
  }, totalAlerts !== 0 || visualizationTotalAlerts !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalAlertsCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 29
    }
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " "), /*#__PURE__*/_react.default.createElement("small", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 27
    }
  }, (0, _translations.ALERTS)(totalAlertsCount)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    key: "alerts-status-open",
    grow: isDonutChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 21
    }
  }, isDonutChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    extraOptions: openDonutOptions,
    getLensAttributes: _alerts_by_status_donut.getAlertsByStatusAttributes,
    height: ChartSize,
    id: `${_types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-open`,
    isDonut: true,
    label: _translations.STATUS_OPEN,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
    timerange: timerange,
    width: ChartSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    onPartitionClick: navigateToAlertsWithStatusOpen,
    data: donutData === null || donutData === void 0 ? void 0 : (_donutData$open2 = donutData.open) === null || _donutData$open2 === void 0 ? void 0 : _donutData$open2.severities,
    fillColor: fillColor,
    height: donutHeight,
    label: _translations.STATUS_OPEN,
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      onClick: navigateToAlertsWithStatusOpen,
      count: openCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 29
      }
    }),
    totalCount: openCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    key: "alerts-status-acknowledged",
    grow: isDonutChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 21
    }
  }, isDonutChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    extraOptions: acknowledgedDonutOptions,
    getLensAttributes: _alerts_by_status_donut.getAlertsByStatusAttributes,
    height: ChartSize,
    id: `${_types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-acknowledged`,
    isDonut: true,
    label: _translations.STATUS_ACKNOWLEDGED,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
    timerange: timerange,
    width: ChartSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: donutData === null || donutData === void 0 ? void 0 : (_donutData$acknowledg3 = donutData.acknowledged) === null || _donutData$acknowledg3 === void 0 ? void 0 : _donutData$acknowledg3.severities,
    fillColor: fillColor,
    height: donutHeight,
    label: _translations.STATUS_ACKNOWLEDGED,
    onPartitionClick: navigateToAlertsWithStatusAcknowledged,
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      onClick: navigateToAlertsWithStatusAcknowledged,
      count: acknowledgedCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 29
      }
    }),
    totalCount: acknowledgedCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(StyledFlexItem, {
    key: "alerts-status-closed",
    grow: isDonutChartEmbeddablesEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 21
    }
  }, isDonutChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    extraOptions: closedDonutOptions,
    getLensAttributes: _alerts_by_status_donut.getAlertsByStatusAttributes,
    height: ChartSize,
    id: `${_types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}-closed`,
    isDonut: true,
    label: _translations.STATUS_CLOSED,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
    timerange: timerange,
    width: ChartSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: donutData === null || donutData === void 0 ? void 0 : (_donutData$closed2 = donutData.closed) === null || _donutData$closed2 === void 0 ? void 0 : _donutData$closed2.severities,
    fillColor: fillColor,
    height: donutHeight,
    label: _translations.STATUS_CLOSED,
    onPartitionClick: navigateToAlertsWithStatusClosed,
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      onClick: navigateToAlertsWithStatusClosed,
      count: closedCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 29
      }
    }),
    totalCount: closedCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 25
    }
  })))), !isDonutChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(StyledLegendFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 19
    }
  }, legendItems.length > 0 && /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    legendItems: legendItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 48
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 15
    }
  })))));
};
exports.AlertsByStatus = AlertsByStatus;