"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ONBOARDING_SEARCH_AI_LAKE_PAGE_TITLE = exports.ONBOARDING_SEARCH_AI_LAKE_PAGE_SUB_DESCRIPTION = exports.ONBOARDING_PAGE_TITLE = exports.ONBOARDING_PAGE_SUBTITLE = exports.ONBOARDING_PAGE_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONBOARDING_PAGE_TITLE = userName => _i18n.i18n.translate('xpack.securitySolution.onboarding.Title', {
  defaultMessage: `Hi {userName}!`,
  values: {
    userName
  }
});
exports.ONBOARDING_PAGE_TITLE = ONBOARDING_PAGE_TITLE;
const ONBOARDING_PAGE_SUBTITLE = exports.ONBOARDING_PAGE_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.subTitle', {
  defaultMessage: `Welcome to Elastic Security`
});
const ONBOARDING_PAGE_DESCRIPTION = exports.ONBOARDING_PAGE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.description', {
  defaultMessage: `A SIEM with AI-driven security analytics, XDR and Cloud Security.`
});
const ONBOARDING_SEARCH_AI_LAKE_PAGE_TITLE = exports.ONBOARDING_SEARCH_AI_LAKE_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.searchAILake.title', {
  defaultMessage: `Welcome to Elastic AI SOC Engine`
});
const ONBOARDING_SEARCH_AI_LAKE_PAGE_SUB_DESCRIPTION = exports.ONBOARDING_SEARCH_AI_LAKE_PAGE_SUB_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.onboarding.searchAILake.subDescription', {
  defaultMessage: `Empowering SOCs for faster threat detection, investigation, and response.`
});