"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOTAL_RULES = exports.START_MIGRATION_INTEGRATIONS_CARD_TITLE = exports.MIGRATION_MISSING_TEXT = exports.MIGRATION_MISSING_BUTTON = exports.DETECTED_TAB_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const START_MIGRATION_INTEGRATIONS_CARD_TITLE = exports.START_MIGRATION_INTEGRATIONS_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.onboarding.migrationIntegrations.title', {
  defaultMessage: 'Add SIEM data with Integrations'
});
const MIGRATION_MISSING_TEXT = exports.MIGRATION_MISSING_TEXT = _i18n.i18n.translate('xpack.securitySolution.onboarding.migrationIntegrations.missingMigration.title', {
  defaultMessage: 'Complete a rule migration to get integration recommendations'
});
const MIGRATION_MISSING_BUTTON = exports.MIGRATION_MISSING_BUTTON = _i18n.i18n.translate('xpack.securitySolution.onboarding.migrationIntegrations.missingMigration.button', {
  defaultMessage: 'Start rule migration'
});
const DETECTED_TAB_LABEL = exports.DETECTED_TAB_LABEL = _i18n.i18n.translate('xpack.securitySolution.onboarding.migrationIntegrations.detectedTabLabel', {
  defaultMessage: 'Detected'
});
const TOTAL_RULES = count => _i18n.i18n.translate('xpack.securitySolution.onboarding.migrationIntegrations.totalRules', {
  values: {
    count
  },
  defaultMessage: '{count} rules'
});
exports.TOTAL_RULES = TOTAL_RULES;