"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userSortedNotes = exports.userSelectedRow = exports.userSelectedPerPage = exports.userSelectedPage = exports.userSelectedNotesForDeletion = exports.userSelectedBulkDelete = exports.userSearchedNotes = exports.userFilteredNotes = exports.userFilterCreatedBy = exports.userFilterAssociatedNotes = exports.userClosedDeleteModal = exports.userClosedCreateErrorToast = exports.selectNotesTableSort = exports.selectNotesTableSelectedIds = exports.selectNotesTableSearch = exports.selectNotesTablePendingDeleteIds = exports.selectNotesTableCreatedByFilter = exports.selectNotesTableAssociatedFilter = exports.selectNotesPagination = exports.selectNotesBySavedObjectIdReversed = exports.selectNotesBySavedObjectId = exports.selectNotesByDocumentIdReversed = exports.selectNotesByDocumentId = exports.selectNoteIds = exports.selectNoteById = exports.selectFetchNotesStatus = exports.selectFetchNotesError = exports.selectFetchNotesBySavedObjectIdsStatus = exports.selectFetchNotesBySavedObjectIdsError = exports.selectFetchNotesByDocumentIdsStatus = exports.selectFetchNotesByDocumentIdsError = exports.selectDocumentNotesBySavedObjectId = exports.selectDeleteNotesStatus = exports.selectDeleteNotesError = exports.selectCreateNoteStatus = exports.selectCreateNoteError = exports.selectAllReversed = exports.selectAllNotes = exports.notesReducer = exports.makeSelectNotesBySavedObjectId = exports.makeSelectNotesByDocumentId = exports.makeSelectDocumentNotesBySavedObjectId = exports.initialNotesState = exports.fetchNotesBySavedObjectIds = exports.fetchNotesByDocumentIds = exports.fetchNotes = exports.fallbackToEmptyArray = exports.deleteNotes = exports.createNote = exports.ReqStatus = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _reselect = require("reselect");
var _constants = require("../../../common/notes/constants");
var _api = require("../api/api");
var _normalize = require("./normalize");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ReqStatus = exports.ReqStatus = /*#__PURE__*/function (ReqStatus) {
  ReqStatus["Idle"] = "idle";
  ReqStatus["Loading"] = "loading";
  ReqStatus["Succeeded"] = "succeeded";
  ReqStatus["Failed"] = "failed";
  return ReqStatus;
}({});
const notesAdapter = (0, _toolkit.createEntityAdapter)({
  selectId: note => note.noteId,
  sortComparer: (a, b) => {
    var _a$created, _b$created;
    const aCreated = (_a$created = a.created) !== null && _a$created !== void 0 ? _a$created : 0;
    const bCreated = (_b$created = b.created) !== null && _b$created !== void 0 ? _b$created : 0;
    return aCreated > bCreated ? 1 : -1;
  }
});
const initialNotesState = exports.initialNotesState = notesAdapter.getInitialState({
  status: {
    fetchNotesByDocumentIds: ReqStatus.Idle,
    fetchNotesBySavedObjectIds: ReqStatus.Idle,
    createNote: ReqStatus.Idle,
    deleteNotes: ReqStatus.Idle,
    fetchNotes: ReqStatus.Idle
  },
  error: {
    fetchNotesByDocumentIds: null,
    fetchNotesBySavedObjectIds: null,
    createNote: null,
    deleteNotes: null,
    fetchNotes: null
  },
  pagination: {
    page: 1,
    perPage: 10,
    total: 0
  },
  sort: {
    field: 'created',
    direction: 'desc'
  },
  filter: '',
  createdByFilter: '',
  associatedFilter: _constants.AssociatedFilter.all,
  search: '',
  selectedIds: [],
  pendingDeleteIds: []
});
const fetchNotesByDocumentIds = exports.fetchNotesByDocumentIds = (0, _toolkit.createAsyncThunk)('notes/fetchNotesByDocumentIds', async args => {
  const {
    documentIds
  } = args;
  const res = await (0, _api.fetchNotesByDocumentIds)(documentIds);
  return (0, _normalize.normalizeEntities)('notes' in res ? res.notes : []);
});
const fetchNotesBySavedObjectIds = exports.fetchNotesBySavedObjectIds = (0, _toolkit.createAsyncThunk)('notes/fetchNotesBySavedObjectIds', async args => {
  const {
    savedObjectIds
  } = args;
  const res = await (0, _api.fetchNotesBySaveObjectIds)(savedObjectIds);
  return (0, _normalize.normalizeEntities)('notes' in res ? res.notes : []);
});
const fetchNotes = exports.fetchNotes = (0, _toolkit.createAsyncThunk)('notes/fetchNotes', async args => {
  const {
    page,
    perPage,
    sortField,
    sortOrder,
    filter,
    createdByFilter,
    associatedFilter,
    search
  } = args;
  const res = await (0, _api.fetchNotes)({
    page,
    perPage,
    sortField,
    sortOrder,
    filter,
    createdByFilter,
    associatedFilter,
    search
  });
  return {
    ...(0, _normalize.normalizeEntities)('notes' in res ? res.notes : []),
    totalCount: 'totalCount' in res ? res.totalCount : 0
  };
});
const createNote = exports.createNote = (0, _toolkit.createAsyncThunk)('notes/createNote', async args => {
  const {
    note
  } = args;
  const res = await (0, _api.createNote)({
    note
  });
  return (0, _normalize.normalizeEntity)(res);
});
const deleteNotes = exports.deleteNotes = (0, _toolkit.createAsyncThunk)('notes/deleteNotes', async (args, {
  dispatch,
  getState
}) => {
  const {
    ids,
    refetch
  } = args;
  await (0, _api.deleteNotes)(ids);
  if (refetch) {
    const state = getState();
    const {
      search,
      pagination,
      createdByFilter,
      associatedFilter,
      sort
    } = state.notes;
    dispatch(fetchNotes({
      page: pagination.page,
      perPage: pagination.perPage,
      sortField: sort.field,
      sortOrder: sort.direction,
      filter: '',
      createdByFilter,
      associatedFilter,
      search
    }));
  }
  return ids;
});
const notesSlice = (0, _toolkit.createSlice)({
  name: 'notes',
  initialState: initialNotesState,
  reducers: {
    userSelectedPage: (state, action) => {
      state.pagination.page = action.payload;
    },
    userSelectedPerPage: (state, action) => {
      state.pagination.perPage = action.payload;
    },
    userSortedNotes: (state, action) => {
      state.sort = action.payload;
    },
    userFilteredNotes: (state, action) => {
      state.filter = action.payload;
    },
    userFilterCreatedBy: (state, action) => {
      state.createdByFilter = action.payload;
    },
    userFilterAssociatedNotes: (state, action) => {
      state.associatedFilter = action.payload;
    },
    userSearchedNotes: (state, action) => {
      state.search = action.payload;
    },
    userSelectedRow: (state, action) => {
      state.selectedIds = action.payload;
    },
    userClosedDeleteModal: state => {
      state.pendingDeleteIds = [];
    },
    userSelectedNotesForDeletion: (state, action) => {
      state.pendingDeleteIds = [action.payload];
    },
    userSelectedBulkDelete: state => {
      state.pendingDeleteIds = state.selectedIds;
    },
    userClosedCreateErrorToast: state => {
      state.error.createNote = null;
    }
  },
  extraReducers(builder) {
    builder.addCase(fetchNotesByDocumentIds.pending, state => {
      state.status.fetchNotesByDocumentIds = ReqStatus.Loading;
    }).addCase(fetchNotesByDocumentIds.fulfilled, (state, action) => {
      notesAdapter.upsertMany(state, action.payload.entities.notes);
      state.status.fetchNotesByDocumentIds = ReqStatus.Succeeded;
    }).addCase(fetchNotesByDocumentIds.rejected, (state, action) => {
      var _action$payload;
      state.status.fetchNotesByDocumentIds = ReqStatus.Failed;
      state.error.fetchNotesByDocumentIds = (_action$payload = action.payload) !== null && _action$payload !== void 0 ? _action$payload : action.error;
    }).addCase(fetchNotesBySavedObjectIds.pending, state => {
      state.status.fetchNotesBySavedObjectIds = ReqStatus.Loading;
    }).addCase(fetchNotesBySavedObjectIds.fulfilled, (state, action) => {
      notesAdapter.upsertMany(state, action.payload.entities.notes);
      state.status.fetchNotesBySavedObjectIds = ReqStatus.Succeeded;
    }).addCase(fetchNotesBySavedObjectIds.rejected, (state, action) => {
      var _action$payload2;
      state.status.fetchNotesBySavedObjectIds = ReqStatus.Failed;
      state.error.fetchNotesBySavedObjectIds = (_action$payload2 = action.payload) !== null && _action$payload2 !== void 0 ? _action$payload2 : action.error;
    }).addCase(createNote.pending, state => {
      state.status.createNote = ReqStatus.Loading;
    }).addCase(createNote.fulfilled, (state, action) => {
      notesAdapter.addMany(state, action.payload.entities.notes);
      state.status.createNote = ReqStatus.Succeeded;
    }).addCase(createNote.rejected, (state, action) => {
      var _action$payload3;
      state.status.createNote = ReqStatus.Failed;
      state.error.createNote = (_action$payload3 = action.payload) !== null && _action$payload3 !== void 0 ? _action$payload3 : action.error;
    }).addCase(deleteNotes.pending, state => {
      state.status.deleteNotes = ReqStatus.Loading;
    }).addCase(deleteNotes.fulfilled, (state, action) => {
      notesAdapter.removeMany(state, action.payload);
      state.status.deleteNotes = ReqStatus.Succeeded;
      state.pendingDeleteIds = state.pendingDeleteIds.filter(value => !action.payload.includes(value));
    }).addCase(deleteNotes.rejected, (state, action) => {
      var _action$payload4;
      state.status.deleteNotes = ReqStatus.Failed;
      state.error.deleteNotes = (_action$payload4 = action.payload) !== null && _action$payload4 !== void 0 ? _action$payload4 : action.error;
    }).addCase(fetchNotes.pending, state => {
      state.status.fetchNotes = ReqStatus.Loading;
    }).addCase(fetchNotes.fulfilled, (state, action) => {
      notesAdapter.setAll(state, action.payload.entities.notes);
      state.pagination.total = action.payload.totalCount;
      state.status.fetchNotes = ReqStatus.Succeeded;
      state.selectedIds = [];
    }).addCase(fetchNotes.rejected, (state, action) => {
      var _action$payload5;
      state.status.fetchNotes = ReqStatus.Failed;
      state.error.fetchNotes = (_action$payload5 = action.payload) !== null && _action$payload5 !== void 0 ? _action$payload5 : action.error;
    });
  }
});
const notesReducer = exports.notesReducer = notesSlice.reducer;
const EMPTY_ARRAY = [];
const fallbackToEmptyArray = array => {
  return array.length === 0 ? EMPTY_ARRAY : array;
};
exports.fallbackToEmptyArray = fallbackToEmptyArray;
const {
  selectAll: selectAllNotes,
  selectById: selectNoteById,
  selectIds: selectNoteIds
} = notesAdapter.getSelectors(state => state.notes);
exports.selectNoteIds = selectNoteIds;
exports.selectNoteById = selectNoteById;
exports.selectAllNotes = selectAllNotes;
const selectFetchNotesByDocumentIdsStatus = state => state.notes.status.fetchNotesByDocumentIds;
exports.selectFetchNotesByDocumentIdsStatus = selectFetchNotesByDocumentIdsStatus;
const selectFetchNotesByDocumentIdsError = state => state.notes.error.fetchNotesByDocumentIds;
exports.selectFetchNotesByDocumentIdsError = selectFetchNotesByDocumentIdsError;
const selectFetchNotesBySavedObjectIdsStatus = state => state.notes.status.fetchNotesBySavedObjectIds;
exports.selectFetchNotesBySavedObjectIdsStatus = selectFetchNotesBySavedObjectIdsStatus;
const selectFetchNotesBySavedObjectIdsError = state => state.notes.error.fetchNotesBySavedObjectIds;
exports.selectFetchNotesBySavedObjectIdsError = selectFetchNotesBySavedObjectIdsError;
const selectIds = state => state.notes.ids;
const selectEntities = state => state.notes.entities;
const selectAllReversed = exports.selectAllReversed = (0, _reselect.createSelector)(selectIds, selectEntities, (ids, entities) =>
// eslint-disable-next-line @typescript-eslint/no-non-null-assertion
[...ids].reverse().map(id => entities[id]));
const selectCreateNoteStatus = state => state.notes.status.createNote;
exports.selectCreateNoteStatus = selectCreateNoteStatus;
const selectCreateNoteError = state => state.notes.error.createNote;
exports.selectCreateNoteError = selectCreateNoteError;
const selectDeleteNotesStatus = state => state.notes.status.deleteNotes;
exports.selectDeleteNotesStatus = selectDeleteNotesStatus;
const selectDeleteNotesError = state => state.notes.error.deleteNotes;
exports.selectDeleteNotesError = selectDeleteNotesError;
const selectNotesPagination = state => state.notes.pagination;
exports.selectNotesPagination = selectNotesPagination;
const selectNotesTableSort = state => state.notes.sort;
exports.selectNotesTableSort = selectNotesTableSort;
const selectNotesTableSelectedIds = state => state.notes.selectedIds;
exports.selectNotesTableSelectedIds = selectNotesTableSelectedIds;
const selectNotesTableSearch = state => state.notes.search;
exports.selectNotesTableSearch = selectNotesTableSearch;
const selectNotesTableCreatedByFilter = state => state.notes.createdByFilter;
exports.selectNotesTableCreatedByFilter = selectNotesTableCreatedByFilter;
const selectNotesTableAssociatedFilter = state => state.notes.associatedFilter;
exports.selectNotesTableAssociatedFilter = selectNotesTableAssociatedFilter;
const selectNotesTablePendingDeleteIds = state => state.notes.pendingDeleteIds;
exports.selectNotesTablePendingDeleteIds = selectNotesTablePendingDeleteIds;
const selectFetchNotesError = state => state.notes.error.fetchNotes;
exports.selectFetchNotesError = selectFetchNotesError;
const selectFetchNotesStatus = state => state.notes.status.fetchNotes;
exports.selectFetchNotesStatus = selectFetchNotesStatus;
const selectNotesByDocumentId = exports.selectNotesByDocumentId = (0, _reselect.createSelector)([selectAllNotes, (_, documentId) => documentId], (notes, documentId) => fallbackToEmptyArray(notes.filter(note => note.eventId === documentId)));
const selectNotesByDocumentIdReversed = exports.selectNotesByDocumentIdReversed = (0, _reselect.createSelector)([selectAllReversed, (_, documentId) => documentId], (notes, documentId) => fallbackToEmptyArray(notes.filter(note => note.eventId === documentId)));
const makeSelectNotesByDocumentId = () => (0, _reselect.createSelector)([selectAllNotes, (_, documentId) => documentId], (notes, documentId) => fallbackToEmptyArray(notes.filter(note => note.eventId === documentId)));
exports.makeSelectNotesByDocumentId = makeSelectNotesByDocumentId;
const selectNotesBySavedObjectId = exports.selectNotesBySavedObjectId = (0, _reselect.createSelector)([selectAllNotes, (_, savedObjectId) => savedObjectId], (notes, savedObjectId) => fallbackToEmptyArray(notes.filter(note => note.timelineId === savedObjectId)));
const selectNotesBySavedObjectIdReversed = exports.selectNotesBySavedObjectIdReversed = (0, _reselect.createSelector)([selectAllReversed, (_, savedObjectId) => savedObjectId], (notes, savedObjectId) => fallbackToEmptyArray(notes.filter(note => note.timelineId === savedObjectId)));
const makeSelectNotesBySavedObjectId = () => (0, _reselect.createSelector)([selectAllNotes, (_, savedObjectId) => savedObjectId], (notes, savedObjectId) => fallbackToEmptyArray(notes.filter(note => note.timelineId === savedObjectId)));
exports.makeSelectNotesBySavedObjectId = makeSelectNotesBySavedObjectId;
const selectDocumentNotesBySavedObjectId = exports.selectDocumentNotesBySavedObjectId = (0, _reselect.createSelector)([selectAllNotes, (_, {
  documentId,
  savedObjectId
}) => ({
  documentId,
  savedObjectId
})], (notes, {
  documentId,
  savedObjectId
}) => fallbackToEmptyArray(notes.filter(note => note.eventId === documentId && note.timelineId === savedObjectId)));
const makeSelectDocumentNotesBySavedObjectId = () => (0, _reselect.createSelector)([selectAllNotes, (_, documentId) => documentId, (_, documentId, savedObjectId) => savedObjectId], (notes, documentId, savedObjectId) => fallbackToEmptyArray(notes.filter(note => note.eventId === documentId && note.timelineId === savedObjectId)));
exports.makeSelectDocumentNotesBySavedObjectId = makeSelectDocumentNotesBySavedObjectId;
const {
  userSelectedPage,
  userSelectedPerPage,
  userSortedNotes,
  userFilteredNotes,
  userFilterCreatedBy,
  userFilterAssociatedNotes,
  userSearchedNotes,
  userSelectedRow,
  userClosedDeleteModal,
  userClosedCreateErrorToast,
  userSelectedNotesForDeletion,
  userSelectedBulkDelete
} = notesSlice.actions;
exports.userSelectedBulkDelete = userSelectedBulkDelete;
exports.userSelectedNotesForDeletion = userSelectedNotesForDeletion;
exports.userClosedCreateErrorToast = userClosedCreateErrorToast;
exports.userClosedDeleteModal = userClosedDeleteModal;
exports.userSelectedRow = userSelectedRow;
exports.userSearchedNotes = userSearchedNotes;
exports.userFilterAssociatedNotes = userFilterAssociatedNotes;
exports.userFilterCreatedBy = userFilterCreatedBy;
exports.userFilteredNotes = userFilteredNotes;
exports.userSortedNotes = userSortedNotes;
exports.userSelectedPerPage = userSelectedPerPage;
exports.userSelectedPage = userSelectedPage;