"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _created_by_filter_dropdown = require("./created_by_filter_dropdown");
var _test_ids = require("./test_ids");
var _ = require("..");
var _constants = require("../../../common/notes/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/search_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACH_FILTER = _i18n.i18n.translate('xpack.securitySolution.notes.management.attachFilter', {
  defaultMessage: 'Attached to'
});
const searchBox = {
  placeholder: 'Search note contents',
  incremental: false,
  'data-test-subj': _test_ids.SEARCH_BAR_TEST_ID
};
const associatedNoteSelectOptions = [{
  value: _constants.AssociatedFilter.all,
  text: 'Anything or nothing'
}, {
  value: _constants.AssociatedFilter.documentOnly,
  text: 'Alerts or events only'
}, {
  value: _constants.AssociatedFilter.savedObjectOnly,
  text: 'Timelines only'
}, {
  value: _constants.AssociatedFilter.documentAndSavedObject,
  text: 'Alerts or events and Timelines only'
}, {
  value: _constants.AssociatedFilter.orphan,
  text: 'Nothing'
}];
const SearchRow = exports.SearchRow = /*#__PURE__*/_react.default.memo(() => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const associatedSelectId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'associatedSelectId'
  });
  const onQueryChange = (0, _react.useCallback)(({
    queryText
  }) => {
    dispatch((0, _.userSearchedNotes)(queryText.trim()));
  }, [dispatch]);
  const onAssociatedNoteSelectChange = (0, _react.useCallback)(e => {
    dispatch((0, _.userFilterAssociatedNotes)(e.target.value));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: searchBox,
    onChange: onQueryChange,
    defaultQuery: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_created_by_filter_dropdown.CreatedByFilterDropdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: associatedSelectId,
    options: associatedNoteSelectOptions,
    onChange: onAssociatedNoteSelectChange,
    prepend: ATTACH_FILTER,
    "aria-label": ATTACH_FILTER,
    "data-test-subj": _test_ids.ASSOCIATED_NOT_SELECT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })));
});
SearchRow.displayName = 'SearchRow';