"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmModal = exports.DELETE_NOTES_CONFIRM = exports.DELETE_NOTES_CANCEL = exports.DELETE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/delete_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.securitySolution.notes.management.deleteAction', {
  defaultMessage: 'Delete'
});
const DELETE_NOTES_CONFIRM = selectedNotes => _i18n.i18n.translate('xpack.securitySolution.notes.management.deleteNotesConfirm', {
  values: {
    selectedNotes
  },
  defaultMessage: 'Are you sure you want to delete {selectedNotes} {selectedNotes, plural, one {note} other {notes}}?'
});
exports.DELETE_NOTES_CONFIRM = DELETE_NOTES_CONFIRM;
const DELETE_NOTES_CANCEL = exports.DELETE_NOTES_CANCEL = _i18n.i18n.translate('xpack.securitySolution.notes.management.deleteNotesCancel', {
  defaultMessage: 'Cancel'
});

/**
 * Renders a confirmation modal to delete notes in the notes management page
 */
const DeleteConfirmModal = exports.DeleteConfirmModal = /*#__PURE__*/_react.default.memo(({
  refetch = true
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const pendingDeleteIds = (0, _reactRedux.useSelector)(_.selectNotesTablePendingDeleteIds);
  const deleteNotesStatus = (0, _reactRedux.useSelector)(_.selectDeleteNotesStatus);
  const deleteLoading = deleteNotesStatus === _.ReqStatus.Loading;
  const onCancel = (0, _react.useCallback)(() => {
    dispatch((0, _.userClosedDeleteModal)());
  }, [dispatch]);
  const onConfirm = (0, _react.useCallback)(() => {
    dispatch((0, _.deleteNotes)({
      ids: pendingDeleteIds,
      refetch
    }));
  }, [dispatch, pendingDeleteIds, refetch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": 'delete-notes-modal',
    title: DELETE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    isLoading: deleteLoading,
    cancelButtonText: DELETE_NOTES_CANCEL,
    confirmButtonText: DELETE,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, DELETE_NOTES_CONFIRM(pendingDeleteIds.length));
});
DeleteConfirmModal.displayName = 'DeleteConfirmModal';