"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRUSTED_APPS_LIST_TYPE = exports.TRUSTED_APPS_EXCEPTION_LIST_DEFINITION = exports.SEARCHABLE_FIELDS = void 0;
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRUSTED_APPS_LIST_TYPE = exports.TRUSTED_APPS_LIST_TYPE = _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT_TRUSTED_APPS;
const SEARCHABLE_FIELDS = exports.SEARCHABLE_FIELDS = [`name`, `description`, 'item_id', `entries.value`, `entries.entries.value`];
const TRUSTED_APPS_EXCEPTION_LIST_DEFINITION = exports.TRUSTED_APPS_EXCEPTION_LIST_DEFINITION = {
  name: _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.name,
  namespace_type: 'agnostic',
  description: _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.description,
  list_id: _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id,
  type: _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT_TRUSTED_APPS
};