"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LOCKED_CARD_BEHAVIOR_TITLE = exports.BehaviourProtectionCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _use_get_protections_unavailable_component = require("../../../hooks/use_get_protections_unavailable_component");
var _reputation_service = require("./components/reputation_service");
var _use_test_id_generator = require("../../../../../../../hooks/use_test_id_generator");
var _setting_card = require("../../setting_card");
var _notify_user_option = require("../../notify_user_option");
var _detect_prevent_protection_level = require("../../detect_prevent_protection_level");
var _protection_setting_card_switch = require("../../protection_setting_card_switch");
var _types = require("../../../../../../../../../common/endpoint/types");
var _use_license = require("../../../../../../../../common/hooks/use_license");
var _setting_locked_card = require("../../setting_locked_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/protection_settings_card/behaviour_protection_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOCKED_CARD_BEHAVIOR_TITLE = exports.LOCKED_CARD_BEHAVIOR_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.behavior', {
  defaultMessage: 'Malicious Behavior'
});
const BEHAVIOUR_OS_VALUES = [_types.PolicyOperatingSystem.windows, _types.PolicyOperatingSystem.mac, _types.PolicyOperatingSystem.linux];
const BehaviourProtectionCard = exports.BehaviourProtectionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const protection = 'behavior_protection';
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.behavior', {
    defaultMessage: 'Malicious behavior protections'
  });
  const selected = (policy && policy.windows[protection].mode) !== _types.ProtectionModes.off;
  if (!isProtectionsAllowed) {
    return null;
  }
  if (!isPlatinumPlus) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: LOCKED_CARD_BEHAVIOR_TITLE,
      "data-test-subj": getTestId('locked'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.behavior_protection', {
      defaultMessage: 'Malicious behavior'
    }),
    selected: selected,
    mode: mode,
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: getTestId(),
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_setting_card_switch.ProtectionSettingCardSwitch, {
      selected: selected,
      policy: policy,
      onChange: onChange,
      mode: mode,
      protection: protection,
      protectionLabel: protectionLabel,
      osList: BEHAVIOUR_OS_VALUES,
      "data-test-subj": getTestId('enableDisableSwitch'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_detect_prevent_protection_level.DetectPreventProtectionLevel, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: BEHAVIOUR_OS_VALUES,
    "data-test-subj": getTestId('protectionLevel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_reputation_service.ReputationService, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    "data-test-subj": getTestId('reputationService'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_notify_user_option.NotifyUserOption, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: BEHAVIOUR_OS_VALUES,
    "data-test-subj": getTestId('notifyUser'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }));
});
BehaviourProtectionCard.displayName = 'BehaviourProtectionCard';