"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MalwareProtectionsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _lodash = require("lodash");
var _use_experimental_features = require("../../../../../../../common/hooks/use_experimental_features");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _notify_user_option = require("../notify_user_option");
var _setting_card = require("../setting_card");
var _types = require("../../../../../../../../common/endpoint/types");
var _protection_setting_card_switch = require("../protection_setting_card_switch");
var _detect_prevent_protection_level = require("../detect_prevent_protection_level");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/malware_protections_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BLOCKLIST_LABELS = {
  label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.blocklistLabel', {
    defaultMessage: 'Blocklist'
  }),
  hint: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.blocklistTooltip', {
    defaultMessage: 'Enables or disables the blocklist associated with this policy. The blocklist is a collection hashes, paths, or signers which extends the list of processes the endpoint considers malicious. See the blocklist tab for entry details.'
  })
};
const ON_WRITE_SCAN_LABELS = {
  label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.onWriteScanLabel', {
    defaultMessage: 'Scan files upon modification'
  }),
  hint: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.onWriteScanTooltip', {
    defaultMessage: "Enables or disables scanning files when they're modified. Disabling this feature improves Endpoint performance."
  }),
  versionCompatibilityHint: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.onWriteVersionCompatibilityHint', {
    defaultMessage: 'Always enabled on Agent versions 8.13 and older.'
  })
};
// NOTE: it mutates `policyConfigData` passed on input
const adjustBlocklistSettingsOnProtectionSwitch = ({
  value,
  policyConfigData,
  protectionOsList
}) => {
  for (const os of protectionOsList) {
    policyConfigData[os].malware.blocklist = value;
  }
  return policyConfigData;
};
const adjustOnWriteSettingsOnProtectionSwitch = ({
  value,
  policyConfigData,
  protectionOsList
}) => {
  for (const os of protectionOsList) {
    policyConfigData[os].malware.on_write_scan = value;
  }
  return policyConfigData;
};
const adjustAllSubfeaturesOnProtectionSwitch = ({
  policyConfigData,
  ...rest
}) => {
  const modifiedPolicy = adjustBlocklistSettingsOnProtectionSwitch({
    policyConfigData,
    ...rest
  });
  return adjustOnWriteSettingsOnProtectionSwitch({
    policyConfigData: modifiedPolicy,
    ...rest
  });
};
const MALWARE_OS_VALUES = [_types.PolicyOperatingSystem.windows, _types.PolicyOperatingSystem.mac, _types.PolicyOperatingSystem.linux];
/**
 * The Malware Protections form for policy details
 * which will configure for all relevant OSes.
 */
const MalwareProtectionsCard = exports.MalwareProtectionsCard = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode = 'edit',
  'data-test-subj': dataTestSubj
}) => {
  const isMalwareOnwriteScanOptionAvailable = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('malwareOnWriteScanOptionAvailable');
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const protection = 'malware';
  const selected = (policy && policy.windows[protection].mode) !== _types.ProtectionModes.off;
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.malware', {
    defaultMessage: 'Malware protections'
  });
  if (!isProtectionsAllowed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.malware', {
      defaultMessage: 'Malware'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: getTestId(),
    selected: selected,
    mode: mode,
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_setting_card_switch.ProtectionSettingCardSwitch, {
      selected: selected,
      protection: protection,
      protectionLabel: protectionLabel,
      osList: MALWARE_OS_VALUES,
      additionalOnSwitchChange: adjustAllSubfeaturesOnProtectionSwitch,
      policy: policy,
      onChange: onChange,
      mode: mode,
      "data-test-subj": getTestId('enableDisableSwitch'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_detect_prevent_protection_level.DetectPreventProtectionLevel, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MALWARE_OS_VALUES,
    "data-test-subj": getTestId('protectionLevel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(SubfeatureSwitch, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    "data-test-subj": getTestId('blocklist'),
    labels: BLOCKLIST_LABELS,
    checked: policy.windows.malware.blocklist,
    adjustSubfeatureOnProtectionSwitch: adjustBlocklistSettingsOnProtectionSwitch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }), isMalwareOnwriteScanOptionAvailable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(SubfeatureSwitch, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    "data-test-subj": getTestId('onWriteScan'),
    labels: ON_WRITE_SCAN_LABELS,
    checked: policy.windows.malware.on_write_scan,
    adjustSubfeatureOnProtectionSwitch: adjustOnWriteSettingsOnProtectionSwitch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_notify_user_option.NotifyUserOption, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MALWARE_OS_VALUES,
    "data-test-subj": getTestId('notifyUser'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }));
});
MalwareProtectionsCard.displayName = 'MalwareProtectionsCard';
const SubfeatureSwitch = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj,
  labels,
  adjustSubfeatureOnProtectionSwitch,
  checked
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEditMode = mode === 'edit';
  const isDisabled = policy.windows.malware.mode === 'off' || !isEditMode;
  const handleBlocklistSwitchChange = (0, _react.useCallback)(event => {
    const value = event.target.checked;
    const newPayload = (0, _lodash.cloneDeep)(policy);
    adjustSubfeatureOnProtectionSwitch({
      value,
      policyConfigData: newPayload,
      protectionOsList: MALWARE_OS_VALUES
    });
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [adjustSubfeatureOnProtectionSwitch, onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: labels.label,
    checked: checked,
    onChange: handleBlocklistSwitchChange,
    disabled: isDisabled,
    "data-test-subj": getTestId('enableDisableSwitch'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 17
      }
    }, labels.hint), labels.versionCompatibilityHint && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 53
      }
    }), labels.versionCompatibilityHint && /*#__PURE__*/_react.default.createElement("i", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 53
      }
    }, labels.versionCompatibilityHint)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  })));
});
SubfeatureSwitch.displayName = 'SubfeatureSwitch';