"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.policyListErrorMessage = exports.PolicyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/fleet-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../../common/components/user_privileges");
var _administration_list_page = require("../../../components/administration_list_page");
var _formatted_date = require("../../../../common/components/formatted_date");
var _endpoint_policy_link = require("../../../components/endpoint_policy_link");
var _use_url_pagination = require("../../../hooks/use_url_pagination");
var _hooks = require("../../../services/policies/hooks");
var _management_empty_state = require("../../../components/management_empty_state");
var _use_navigate_to_app_event_handler = require("../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _constants = require("../../../../../common/constants");
var _routing = require("../../../common/routing");
var _kibana = require("../../../../common/lib/kibana");
var _policy_endpoint_count = require("./components/policy_endpoint_count");
var _management_empty_state_wrapper = require("../../../components/management_empty_state_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const policyListErrorMessage = exports.policyListErrorMessage = _i18n.i18n.translate('xpack.securitySolution.policy.list.errorMessage', {
  defaultMessage: 'Error while retrieving list of policies'
});
const policyListErrorToastTitle = _i18n.i18n.translate('xpack.securitySolution.policy.list.errorMessage.toast.title', {
  defaultMessage: 'Failed to retrieve policy list'
});
const policyListErrorToastText = _i18n.i18n.translate('xpack.securitySolution.policyList.packageVersionError', {
  defaultMessage: 'Error retrieving the endpoint package version'
});
const PolicyList = exports.PolicyList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canReadEndpointList,
    loading: authLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isProtectionUpdatesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('protectionUpdatesEnabled');
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _use_url_pagination.useUrlPagination)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const toasts = (0, _kibana.useToasts)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // load the list of policies
  const {
    data,
    isFetching: policyIsFetching,
    error
  } = (0, _hooks.useGetEndpointSpecificPolicies)({
    page: pagination.page,
    perPage: pagination.pageSize,
    onError: err => {
      toasts.addDanger({
        title: policyListErrorToastTitle,
        text: err.message
      });
    }
  });
  const {
    data: outdatedManifestsCountResponse,
    isLoading: isOutdatedManifestsCountLoading
  } = (0, _hooks.useEndpointPackagePoliciesStats)(isProtectionUpdatesEnabled);

  // grab endpoint version for empty page
  const {
    data: endpointPackageInfo,
    isFetching: packageIsFetching
  } = (0, _hooks.useGetEndpointSecurityPackage)({
    customQueryOptions: {
      onError: err => {
        toasts.addDanger({
          title: policyListErrorToastText,
          text: err.message
        });
      }
    }
  });
  const totalItemCount = (0, _react.useMemo)(() => {
    var _data$total;
    return (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0;
  }, [data]);
  const shouldShowOnboarding = (0, _react.useMemo)(() => !policyIsFetching && totalItemCount === 0 && !error, [policyIsFetching, totalItemCount, error]);
  const policyListPath = (0, _react.useMemo)(() => (0, _routing.getPoliciesPath)(search), [search]);
  const backLink = (0, _react.useMemo)(() => {
    return {
      navigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }],
      label: _i18n.i18n.translate('xpack.securitySolution.policy.backToPolicyList', {
        defaultMessage: 'Back to policy list'
      }),
      href: getAppUrl({
        path: policyListPath
      })
    };
  }, [getAppUrl, policyListPath]);
  const handleCreatePolicyClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)('fleet', {
    path: _public.pagePathGetters.add_integration_to_policy({
      pkgkey: endpointPackageInfo ? `/endpoint-${endpointPackageInfo === null || endpointPackageInfo === void 0 ? void 0 : endpointPackageInfo.version}` : ''
    })[1],
    state: {
      onCancelNavigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }],
      onCancelUrl: getAppUrl({
        path: (0, _routing.getPoliciesPath)()
      }),
      onSaveNavigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }]
    }
  });
  const outdatedManifestsCallOut = (0, _react.useMemo)(() => {
    if (!isProtectionUpdatesEnabled || isOutdatedManifestsCountLoading || !outdatedManifestsCountResponse || outdatedManifestsCountResponse.outdatedManifestsCount === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: 'warning',
      size: "m",
      "data-test-subj": "policy-list-outdated-manifests-call-out",
      title: _i18n.i18n.translate('xpack.securitySolution.policy.list.outdatedManifestsCallOut', {
        defaultMessage: 'Updates available for {outdatedManifestsCount} {outdatedManifestsCount, plural, one {policy} other {policies}}',
        values: {
          outdatedManifestsCount: outdatedManifestsCountResponse.outdatedManifestsCount
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 7
      }
    });
  }, [isOutdatedManifestsCountLoading, isProtectionUpdatesEnabled, outdatedManifestsCountResponse]);
  const policyColumns = (0, _react.useMemo)(() => {
    const updatedAtColumnName = _i18n.i18n.translate('xpack.securitySolution.policy.list.updatedAt', {
      defaultMessage: 'Last Updated'
    });
    const createdAtColumnName = _i18n.i18n.translate('xpack.securitySolution.policy.list.createdAt', {
      defaultMessage: 'Date Created'
    });
    const generateDeployedVersionEntry = version => {
      if (!version) {
        return [];
      }
      if (version === 'latest') {
        return ['success', _i18n.i18n.translate('xpack.securitySolution.policy.list.manifestLatest', {
          defaultMessage: 'latest'
        })];
      }
      const parsedDate = _moment.default.utc(version, 'YYYY-MM-DD');
      if (parsedDate < _moment.default.utc().subtract(18, 'months')) {
        return ['danger', parsedDate.format('MMMM DD, YYYY'), _i18n.i18n.translate('xpack.securitySolution.policy.list.manifestOver18MonthsOld', {
          defaultMessage: 'Manifest is over 18 months old and rollback is not supported'
        })];
      }
      if (parsedDate > _moment.default.utc().subtract(1, 'month')) {
        return ['success', parsedDate.format('MMMM DD, YYYY')];
      }
      return [euiTheme.colors.warning, parsedDate.format('MMMM DD, YYYY'), _i18n.i18n.translate('xpack.securitySolution.policy.list.manifestOver1MonthOld', {
        defaultMessage: 'Manifest is over a month old'
      })];
    };
    return [{
      field: '',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.name', {
        defaultMessage: 'Name'
      }),
      truncateText: true,
      render: policy => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: policy.name,
          anchorClassName: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 235,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_link.EndpointPolicyLink, {
          policyId: policy.id,
          className: "eui-textTruncate",
          "data-test-subj": "policyNameCellLink",
          backLink: backLink,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 236,
            columnNumber: 15
          }
        }, policy.name));
      }
    }, ...(isProtectionUpdatesEnabled ? [{
      field: '',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.deployedVersion', {
        defaultMessage: 'Deployed Version'
      }),
      truncateText: true,
      render: policy => {
        var _policy$inputs$, _policy$inputs$$confi;
        const [color, displayText, tooltip] = generateDeployedVersionEntry((_policy$inputs$ = policy.inputs[0]) === null || _policy$inputs$ === void 0 ? void 0 : (_policy$inputs$$confi = _policy$inputs$.config) === null || _policy$inputs$$confi === void 0 ? void 0 : _policy$inputs$$confi.policy.value.global_manifest_version);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          gutterSize: 'xs',
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 262,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 263,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          type: 'dot',
          color: color,
          content: tooltip,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 264,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "policyDeployedVersion",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 23
          }
        }, displayText)));
      }
    }] : []), {
      field: 'created_by',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.createdBy', {
        defaultMessage: 'Created by'
      }),
      truncateText: true,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          gutterSize: 'xs',
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 285,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 286,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
          name: name,
          "data-test-subj": 'created-by-avatar',
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 289,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "created-by-name",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 17
          }
        }, name)));
      }
    }, {
      field: 'created_at',
      name: createdAtColumnName,
      truncateText: true,
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          fieldName: createdAtColumnName,
          value: date,
          className: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 304,
            columnNumber: 13
          }
        });
      }
    }, {
      field: 'updated_by',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.lastUpdatedBy', {
        defaultMessage: 'Last updated by'
      }),
      truncateText: true,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          gutterSize: 'xs',
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 320,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 321,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
          name: name,
          "data-test-subj": 'updated-by-avatar',
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 322,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 324,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "updated-by-name",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 325,
            columnNumber: 17
          }
        }, name)));
      }
    }, {
      field: 'updated_at',
      name: updatedAtColumnName,
      truncateText: true,
      render: date => {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          fieldName: updatedAtColumnName,
          value: date,
          className: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 339,
            columnNumber: 13
          }
        });
      }
    }, {
      field: '',
      name: _i18n.i18n.translate('xpack.securitySolution.policy.list.endpoints', {
        defaultMessage: 'Endpoints'
      }),
      width: '8%',
      render: policy => {
        var _policy$agents;
        const count = (_policy$agents = policy.agents) !== null && _policy$agents !== void 0 ? _policy$agents : 0;
        return /*#__PURE__*/_react.default.createElement(_policy_endpoint_count.PolicyEndpointCount, {
          className: "eui-textTruncate",
          "data-test-subj": "policyEndpointCountLink",
          policyId: policy.id,
          nonLinkCondition: authLoading || !canReadEndpointList || count === 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 357,
            columnNumber: 13
          }
        }, count);
      }
    }];
  }, [isProtectionUpdatesEnabled, euiTheme.colors.warning, backLink, authLoading, canReadEndpointList]);
  const handleTableOnChange = (0, _react.useCallback)(({
    page
  }) => {
    setPagination({
      page: page.index + 1,
      pageSize: page.size
    });
  }, [setPagination]);
  const tablePagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.page - 1,
      pageSize: pagination.pageSize,
      totalItemCount,
      pageSizeOptions
    };
  }, [totalItemCount, pageSizeOptions, pagination.page, pagination.pageSize]);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "policyListPage",
    hideHeader: shouldShowOnboarding,
    title: _i18n.i18n.translate('xpack.securitySolution.policy.list.title', {
      defaultMessage: 'Policies'
    }),
    subtitle: _i18n.i18n.translate('xpack.securitySolution.policy.list.subtitle', {
      defaultMessage: 'Use policies to customize endpoint and cloud workload protections and other configurations'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 5
    }
  }, !shouldShowOnboarding ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "endpointListTableTotal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.policy.list.totalCount",
    defaultMessage: "Showing {totalItemCount, plural, one {# policy} other {# policies}}",
    values: {
      totalItemCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 11
    }
  }), outdatedManifestsCallOut, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "policyListTable",
    items: (data === null || data === void 0 ? void 0 : data.items) || [],
    columns: policyColumns,
    pagination: tablePagination,
    onChange: handleTableOnChange,
    loading: policyIsFetching,
    error: error !== null ? policyListErrorMessage : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_management_empty_state.PolicyEmptyState, {
    loading: packageIsFetching,
    onActionClick: handleCreatePolicyClick,
    policyEntryPoint: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  })));
});
PolicyList.displayName = 'PolicyList';