"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_LIST_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_LIST_LABELS = exports.POLICY_ARTIFACT_LIST_LABELS = Object.freeze({
  listTotalItemCountMessage: totalItemsCount => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.totalItemCount', {
    defaultMessage: 'Showing {totalItemsCount, plural, one {# artifact} other {# artifacts}}',
    values: {
      totalItemsCount
    }
  }),
  listFullDetailsActionTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.fullDetailsAction', {
    defaultMessage: 'View full details'
  }),
  listRemoveActionTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeAction', {
    defaultMessage: 'Remove from policy'
  }),
  listRemoveActionNotAllowedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.removeActionNotAllowed', {
    defaultMessage: 'Globally applied artifact cannot be removed from policy.'
  }),
  listSearchPlaceholderMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.list.search.placeholder', {
    defaultMessage: `Search on the fields below: name, description, value`
  })
});