"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiQueryParams = exports.totalHits = exports.sortField = exports.sortDirection = exports.showView = exports.selectedPolicyId = exports.searchBarQuery = exports.policyItemsLoading = exports.policyItems = exports.patternsError = exports.patterns = exports.pageSize = exports.pageIndex = exports.nonExistingPolicies = exports.metadataTransformStats = exports.listLoading = exports.listError = exports.listData = exports.isOnEndpointPage = exports.isMetadataTransformStatsLoading = exports.isInitialized = exports.isAutoRefreshEnabled = exports.hasSelectedEndpoint = exports.getWasIsolationRequestSuccessful = exports.getMetadataTransformStats = exports.getIsolationRequestError = exports.getIsIsolationRequestPending = exports.getIsEndpointPackageInfoUninitialized = exports.getCurrentIsolationRequestState = exports.endpointsExist = exports.endpointPackageVersion = exports.endpointPackageInfo = exports.autoRefreshInterval = void 0;
var _querystring = _interopRequireDefault(require("querystring"));
var _reselect = require("reselect");
var _reactRouterDom = require("react-router-dom");
var _rison = require("@kbn/rison");
var _routing = require("../../../common/routing");
var _constants = require("../../../common/constants");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-nodejs-modules

const listData = state => state.hosts;
exports.listData = listData;
const pageIndex = state => state.pageIndex;
exports.pageIndex = pageIndex;
const pageSize = state => state.pageSize;
exports.pageSize = pageSize;
const sortField = state => state.sortField;
exports.sortField = sortField;
const sortDirection = state => state.sortDirection;
exports.sortDirection = sortDirection;
const totalHits = state => state.total;
exports.totalHits = totalHits;
const listLoading = state => state.loading;
exports.listLoading = listLoading;
const listError = state => state.error;
exports.listError = listError;
const policyItems = state => state.policyItems;
exports.policyItems = policyItems;
const policyItemsLoading = state => state.policyItemsLoading;
exports.policyItemsLoading = policyItemsLoading;
const isInitialized = state => state.isInitialized;
exports.isInitialized = isInitialized;
const selectedPolicyId = state => state.selectedPolicyId;
exports.selectedPolicyId = selectedPolicyId;
const endpointPackageInfo = state => state.endpointPackageInfo;
exports.endpointPackageInfo = endpointPackageInfo;
const getIsEndpointPackageInfoUninitialized = exports.getIsEndpointPackageInfoUninitialized = (0, _reselect.createSelector)(endpointPackageInfo, packageInfo => (0, _state.isUninitialisedResourceState)(packageInfo));
const isAutoRefreshEnabled = state => state.isAutoRefreshEnabled;
exports.isAutoRefreshEnabled = isAutoRefreshEnabled;
const autoRefreshInterval = state => state.autoRefreshInterval;
exports.autoRefreshInterval = autoRefreshInterval;
const endpointPackageVersion = exports.endpointPackageVersion = (0, _reselect.createSelector)(endpointPackageInfo, info => (0, _state.isLoadedResourceState)(info) ? info.data.version : undefined);

/**
 * Returns the index patterns for the SearchBar to use for auto-suggest
 */
const patterns = state => state.patterns;
exports.patterns = patterns;
const patternsError = state => state.patternsError;
exports.patternsError = patternsError;
const isOnEndpointPage = state => {
  var _state$location$pathn, _state$location;
  return (0, _reactRouterDom.matchPath)((_state$location$pathn = (_state$location = state.location) === null || _state$location === void 0 ? void 0 : _state$location.pathname) !== null && _state$location$pathn !== void 0 ? _state$location$pathn : '', {
    path: _constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH,
    exact: true
  }) !== null;
};

/** Sanitized list of URL query params supported by the Details page */
exports.isOnEndpointPage = isOnEndpointPage;
const uiQueryParams = exports.uiQueryParams = (0, _reselect.createSelector)(state => state.location, location => {
  const data = {
    page_index: String(_constants.MANAGEMENT_DEFAULT_PAGE),
    page_size: String(_constants.MANAGEMENT_DEFAULT_PAGE_SIZE)
  };
  if (location) {
    // Removes the `?` from the beginning of query string if it exists
    const query = _querystring.default.parse(location.search.slice(1));
    const paginationParams = (0, _routing.extractListPaginationParams)(query);
    const keys = ['selected_endpoint', 'show', 'admin_query', 'sort_field', 'sort_direction'];
    const allowedShowValues = ['policy_response', 'details', 'isolate', 'unisolate', 'activity_log'];
    for (const key of keys) {
      const value = typeof query[key] === 'string' ? query[key] : Array.isArray(query[key]) ? query[key][query[key].length - 1] : undefined;
      if (value !== undefined) {
        if (key === 'show') {
          if (allowedShowValues.includes(value)) {
            data[key] = value;
          }
        } else if (key === 'sort_direction') {
          if (['asc', 'desc'].includes(value)) {
            data[key] = value;
          }
        } else if (key === 'sort_field') {
          data[key] = value;
        } else {
          data[key] = value;
        }
      }
    }
    data.page_size = String(paginationParams.page_size);
    data.page_index = String(paginationParams.page_index);
  }
  return data;
});
const hasSelectedEndpoint = exports.hasSelectedEndpoint = (0, _reselect.createSelector)(uiQueryParams, ({
  selected_endpoint: selectedEndpoint
}) => {
  return selectedEndpoint !== undefined;
});

/** What policy details panel view to show */
const showView = exports.showView = (0, _reselect.createSelector)(uiQueryParams, searchParams => {
  var _searchParams$show;
  return (_searchParams$show = searchParams.show) !== null && _searchParams$show !== void 0 ? _searchParams$show : 'details';
});

/**
 * returns the list of known non-existing polices that may have been in the Endpoint API response.
 * @param state
 */
const nonExistingPolicies = state => state.nonExistingPolicies;

/**
 * Return boolean that indicates whether endpoints exist
 * @param state
 */
exports.nonExistingPolicies = nonExistingPolicies;
const endpointsExist = state => state.endpointsExist;

/**
 * Returns query text from query bar
 */
exports.endpointsExist = endpointsExist;
const searchBarQuery = exports.searchBarQuery = (0, _reselect.createSelector)(uiQueryParams, ({
  admin_query: adminQuery
}) => {
  const decodedQuery = {
    query: '',
    language: 'kuery'
  };
  if (adminQuery) {
    const urlDecodedQuery = (0, _rison.decode)(adminQuery);
    if (urlDecodedQuery && typeof urlDecodedQuery.query === 'string') {
      decodedQuery.query = urlDecodedQuery.query;
    }
    if (urlDecodedQuery && typeof urlDecodedQuery.language === 'string' && (urlDecodedQuery.language === 'kuery' || urlDecodedQuery.language === 'lucene')) {
      decodedQuery.language = urlDecodedQuery.language;
    }
  }
  return decodedQuery;
});
const getCurrentIsolationRequestState = state => {
  return state.isolationRequestState;
};
exports.getCurrentIsolationRequestState = getCurrentIsolationRequestState;
const getIsIsolationRequestPending = exports.getIsIsolationRequestPending = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => (0, _state.isLoadingResourceState)(isolateHost));
const getWasIsolationRequestSuccessful = exports.getWasIsolationRequestSuccessful = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => (0, _state.isLoadedResourceState)(isolateHost));
const getIsolationRequestError = exports.getIsolationRequestError = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => {
  if ((0, _state.isFailedResourceState)(isolateHost)) {
    return isolateHost.error;
  }
});
const getMetadataTransformStats = state => state.metadataTransformStats;
exports.getMetadataTransformStats = getMetadataTransformStats;
const metadataTransformStats = state => (0, _state.isLoadedResourceState)(state.metadataTransformStats) ? state.metadataTransformStats.data : [];
exports.metadataTransformStats = metadataTransformStats;
const isMetadataTransformStatsLoading = state => (0, _state.isLoadingResourceState)(state.metadataTransformStats);
exports.isMetadataTransformStatsLoading = isMetadataTransformStatsLoading;