"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommandAboutInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/lib/get_command_about_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UNSUPPORTED_COMMAND_INFO = _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.unsupportedCommandInfo', {
  defaultMessage: 'This version of the Endpoint does not support this command. Upgrade your Agent in Fleet to use the latest response actions.'
});
const getCommandAboutInfo = ({
  aboutInfo,
  isSupported,
  tooltipContent = UNSUPPORTED_COMMAND_INFO,
  dataTestSubj
}) => {
  return isSupported ? aboutInfo : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, aboutInfo, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    anchorProps: {
      'data-test-subj': dataTestSubj
    },
    content: tooltipContent,
    type: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
exports.getCommandAboutInfo = getCommandAboutInfo;