"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScanActionResult = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_scan_request = require("../../../hooks/response_actions/use_send_scan_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScanActionResult = exports.ScanActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin5, _command$commandDefin6, _command$commandDefin7, _command$commandDefin8;
  const actionCreator = (0, _use_send_scan_request.useSendScanRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$commandDefin3, _command$commandDefin4;
    const endpointId = (_command$commandDefin = command.commandDefinition) === null || _command$commandDefin === void 0 ? void 0 : (_command$commandDefin2 = _command$commandDefin.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
    const {
      path,
      comment
    } = command.args.args;
    const agentType = (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : (_command$commandDefin4 = _command$commandDefin3.meta) === null || _command$commandDefin4 === void 0 ? void 0 : _command$commandDefin4.agentType;
    return endpointId ? {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      comment: comment === null || comment === void 0 ? void 0 : comment[0],
      parameters: {
        path: path[0]
      }
    } : undefined;
  }, [command.args.args, (_command$commandDefin5 = command.commandDefinition) === null || _command$commandDefin5 === void 0 ? void 0 : (_command$commandDefin6 = _command$commandDefin5.meta) === null || _command$commandDefin6 === void 0 ? void 0 : _command$commandDefin6.agentType, (_command$commandDefin7 = command.commandDefinition) === null || _command$commandDefin7 === void 0 ? void 0 : (_command$commandDefin8 = _command$commandDefin7.meta) === null || _command$commandDefin8 === void 0 ? void 0 : _command$commandDefin8.endpointId]);
  return (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'scan',
    pendingMessage: _i18n.i18n.translate('xpack.securitySolution.scanAction.pendingMessage', {
      defaultMessage: 'File path scan is in progress.'
    })
  }).result;
});
ScanActionResult.displayName = 'ScanActionResult';