"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputPlaceholder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_with_input_text_entered = require("../../../hooks/state_selectors/use_with_input_text_entered");
var _use_with_input_placeholder = require("../../../hooks/state_selectors/use_with_input_placeholder");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_input/components/input_placeholder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InputPlaceholderContainer = (0, _styledComponents.default)(_eui.EuiText)`
  position: absolute;
  pointer-events: none;
  padding-left: 0.5em;
  width: 96%;
  color: ${({
  theme: {
    eui
  }
}) => eui.euiFormControlPlaceholderText};
  user-select: none;
`;
const InputPlaceholder = exports.InputPlaceholder = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    fullTextEntered
  } = (0, _use_with_input_text_entered.useWithInputTextEntered)();
  const placeholder = (0, _use_with_input_placeholder.useWithInputPlaceholder)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  if (fullTextEntered.length > 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(InputPlaceholderContainer, {
    size: "s",
    className: "eui-textTruncate",
    "data-test-subj": getTestId('inputPlaceholder'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, placeholder));
});
InputPlaceholder.displayName = 'InputPlaceholder';