"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedUserAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _left_panel_header = require("../../shared/components/left_panel/left_panel_header");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _formatted_date = require("../../../../common/components/formatted_date");
var _constants = require("../../shared/constants");
var _model = require("../../../../explore/users/store/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/components/managed_user_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManagedUserAccordion = ({
  children,
  title,
  managedUser,
  tableType,
  openDetailsPanel,
  isLinkEnabled,
  isPreviewMode
}) => {
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  const timestamp = (0, _fp.get)('@timestamp[0]', managedUser);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    "data-test-subj": `managed-user-accordion-${tableType}`,
    header: {
      title,
      iconType: !isPreviewMode ? 'arrowStart' : undefined,
      headerContent: timestamp && /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
              font-size: ${xsFontSize};
            `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.timeline.userDetails.updatedTime",
        defaultMessage: "Updated {time}",
        values: {
          time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: timestamp,
            dateFormat: "MMM D, YYYY",
            relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 61,
              columnNumber: 19
            }
          })
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      })),
      link: {
        callback: isLinkEnabled ? () => openDetailsPanel({
          tab: tableType === _model.UserAssetTableType.assetOkta ? _left_panel_header.EntityDetailsLeftPanelTab.OKTA : _left_panel_header.EntityDetailsLeftPanelTab.ENTRA
        }) : undefined,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.showAssetDocument",
          defaultMessage: "Show asset details",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 13
          }
        })
      }
    },
    expand: {
      expandable: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, children);
};
exports.ManagedUserAccordion = ManagedUserAccordion;