"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _basic_table = require("../../../../../common/components/ml/tables/basic_table");
var _columns = require("./columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/components/entity_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EntityTable = ({
  contextID,
  scopeId,
  data,
  entityFields
}) => {
  const items = (0, _react.useMemo)(() => entityFields.filter(({
    isVisible
  }) => isVisible ? isVisible(data) : true), [data, entityFields]);
  const entityTableColumns = (0, _react.useMemo)(() => (0, _columns.getEntityTableColumns)(contextID, scopeId, data), [contextID, scopeId, data]);
  return /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
    loading: data.isLoading,
    "data-test-subj": "entity-table",
    columns: entityTableColumns,
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.EntityTable = EntityTable;