"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToAnalyzer = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _left = require("../../left");
var _kibana = require("../../../../common/lib/kibana");
var _analyze_graph = require("../../left/components/analyze_graph");
var _panel_keys = require("../constants/panel_keys");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns a callback to navigate to the analyzer in the flyout
 */
const useNavigateToAnalyzer = ({
  isFlyoutOpen,
  eventId,
  indexName,
  scopeId,
  isPreviewMode
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const right = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId]);
  const left = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsLeftPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    },
    path: {
      tab: _left.LeftPanelVisualizeTab,
      subTab: _analyze_graph.ANALYZE_GRAPH_ID
    }
  }), [eventId, indexName, scopeId]);
  const navigateToAnalyzer = (0, _react.useCallback)(() => {
    // open left panel and preview panel if not in preview mode
    if (isFlyoutOpen && !isPreviewMode) {
      openLeftPanel(left);
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutTabClicked, {
        location: scopeId,
        panel: 'left',
        tabId: _left.LeftPanelVisualizeTab
      });
    }
    // if flyout is not currently open, open flyout with right, left and preview panel
    // if new navigation is enabled and in preview mode, open flyout with right, left and preview panel
    else if (!isFlyoutOpen || isNewNavigationEnabled && isPreviewMode) {
      openFlyout({
        right,
        left
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: scopeId,
        panel: 'left'
      });
    }
  }, [openFlyout, openLeftPanel, right, left, scopeId, telemetry, isFlyoutOpen, isNewNavigationEnabled, isPreviewMode]);
  return (0, _react.useMemo)(() => ({
    navigateToAnalyzer
  }), [navigateToAnalyzer]);
};
exports.useNavigateToAnalyzer = useNavigateToAnalyzer;