"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGraphPreview = void 0;
var _fp = require("lodash/fp");
var _utils = require("../utils");
var _use_basic_data_from_details_data = require("./use_basic_data_from_details_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface for the result of the useGraphPreview hook
 */

/**
 * Hook that returns the graph view configuration if the graph view is available for the alert
 */
const useGraphPreview = ({
  getFieldsData,
  ecsData,
  dataFormattedForFieldBrowser
}) => {
  const timestamp = (0, _utils.getField)(getFieldsData('@timestamp'));
  const originalEventId = getFieldsData('kibana.alert.original_event.id');
  const eventId = getFieldsData('event.id');
  const eventIds = originalEventId ? (0, _utils.getFieldArray)(originalEventId) : (0, _utils.getFieldArray)(eventId);
  const actorIds = (0, _utils.getFieldArray)(getFieldsData('actor.entity.id'));
  const targetIds = (0, _utils.getFieldArray)(getFieldsData('target.entity.id'));
  const action = (0, _fp.get)(['event', 'action'], ecsData);
  const hasGraphRepresentation = Boolean(timestamp) && Boolean(action === null || action === void 0 ? void 0 : action.length) && actorIds.length > 0 && eventIds.length > 0 && targetIds.length > 0;
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  return {
    timestamp,
    eventIds,
    actorIds,
    action,
    targetIds,
    hasGraphRepresentation,
    isAlert
  };
};
exports.useGraphPreview = useGraphPreview;