"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponseActionsView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _test_ids = require("../components/test_ids");
var _response_actions_results = require("../../../../common/components/response_actions/response_actions_results");
var _expand_dotted = require("../../../../../common/utils/expand_dotted");
var _use_get_automated_action_list = require("../../../../management/hooks/response_actions/use_get_automated_action_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/hooks/use_response_actions_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RESPONSE_ACTIONS_VIEW = _i18n.i18n.translate('xpack.securitySolution.flyout.response.responseActionsView', {
  defaultMessage: 'Response Results'
});
const TabContentWrapper = _styled.default.div`
  height: 100%;
  position: relative;
`;
const InlineBlock = _styled.default.div`
  display: inline-block;
  line-height: 1.7em;
`;
const EmptyResponseActions = () => {
  return /*#__PURE__*/_react.default.createElement(InlineBlock, {
    "data-test-subj": _test_ids.RESPONSE_NO_DATA_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.noDataDescription",
    defaultMessage: "There are no response actions defined for this event. To add some, edit the rule's settings and set up {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/rules-ui-create.html#rule-response-action",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.left.response.noDataLinkText",
        defaultMessage: "response actions",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
const viewData = {
  id: 'response-actions-results-view',
  name: RESPONSE_ACTIONS_VIEW
};
/**
 *
 */
const useResponseActionsView = ({
  rawEventData,
  ecsData
}) => {
  var _expandedEventFieldsO, _expandedEventFieldsO2, _expandedEventFieldsO3, _expandedEventFieldsO4, _rawEventData$_id;
  const expandedEventFieldsObject = rawEventData ? (0, _expand_dotted.expandDottedObject)(rawEventData.fields) : undefined;
  const responseActions = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO === void 0 ? void 0 : (_expandedEventFieldsO2 = _expandedEventFieldsO.alert) === null || _expandedEventFieldsO2 === void 0 ? void 0 : (_expandedEventFieldsO3 = _expandedEventFieldsO2.rule) === null || _expandedEventFieldsO3 === void 0 ? void 0 : (_expandedEventFieldsO4 = _expandedEventFieldsO3.parameters) === null || _expandedEventFieldsO4 === void 0 ? void 0 : _expandedEventFieldsO4[0].response_actions;
  const shouldEarlyReturn = !rawEventData;
  const alertId = (_rawEventData$_id = rawEventData === null || rawEventData === void 0 ? void 0 : rawEventData._id) !== null && _rawEventData$_id !== void 0 ? _rawEventData$_id : '';
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data: automatedList,
    isFetched
  } = (0, _use_get_automated_action_list.useGetAutomatedActionList)({
    alertIds: [alertId]
  }, {
    enabled: !shouldEarlyReturn,
    isLive
  });

  // calculating whether or not our useGetAutomatedActionList (react-query) should try to refetch data
  (0, _react.useEffect)(() => {
    setIsLive(() => {
      var _automatedList$items;
      return !(!(responseActions !== null && responseActions !== void 0 && responseActions.length) || !!(automatedList !== null && automatedList !== void 0 && (_automatedList$items = automatedList.items) !== null && _automatedList$items !== void 0 && _automatedList$items.length));
    });
  }, [automatedList, responseActions === null || responseActions === void 0 ? void 0 : responseActions.length]);
  if (shouldEarlyReturn) {
    return {
      ...viewData,
      content: /*#__PURE__*/_react.default.createElement(EmptyResponseActions, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 16
        }
      })
    };
  } else {
    var _expandedEventFieldsO5, _expandedEventFieldsO6, _expandedEventFieldsO7, _expandedEventFieldsO8, _automatedList$items2;
    const ruleName = expandedEventFieldsObject === null || expandedEventFieldsObject === void 0 ? void 0 : (_expandedEventFieldsO5 = expandedEventFieldsObject.kibana) === null || _expandedEventFieldsO5 === void 0 ? void 0 : (_expandedEventFieldsO6 = _expandedEventFieldsO5.alert) === null || _expandedEventFieldsO6 === void 0 ? void 0 : (_expandedEventFieldsO7 = _expandedEventFieldsO6.rule) === null || _expandedEventFieldsO7 === void 0 ? void 0 : (_expandedEventFieldsO8 = _expandedEventFieldsO7.name) === null || _expandedEventFieldsO8 === void 0 ? void 0 : _expandedEventFieldsO8[0];
    const automatedListItems = (_automatedList$items2 = automatedList === null || automatedList === void 0 ? void 0 : automatedList.items) !== null && _automatedList$items2 !== void 0 ? _automatedList$items2 : [];
    return {
      ...viewData,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": "response-actions-notification",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 9
        }
      }, automatedListItems.length),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(TabContentWrapper, {
        "data-test-subj": "responseActionsViewWrapper",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 11
        }
      }, isFetched && !!automatedListItems.length ? /*#__PURE__*/_react.default.createElement(_response_actions_results.ResponseActionsResults, {
        actions: automatedListItems,
        ruleName: ruleName,
        ecsData: ecsData,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react.default.createElement(EmptyResponseActions, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 15
        }
      })))
    };
  }
};
exports.useResponseActionsView = useResponseActionsView;