"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersAnomaliesJobIdFilterSelector = exports.usersAnomaliesIntervalSelector = exports.userRiskScoreSeverityFilterSelector = exports.userRiskScoreSelector = exports.selectUserAssetTables = exports.selectUserAssetTableById = exports.authenticationsSelector = exports.allUsersSelector = void 0;
var _reselect = require("reselect");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectUserPage = state => state.users.page;
const selectUsersAndDetailsPage = (state, usersType) => {
  if (usersType === _model.UsersType.details || usersType === _model.UsersType.page) {
    return state.users[usersType];
  }
  return null;
};
const allUsersSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.allUsers]);
exports.allUsersSelector = allUsersSelector;
const userRiskScoreSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.risk]);
exports.userRiskScoreSelector = userRiskScoreSelector;
const userRiskScoreSeverityFilterSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.risk].severitySelection);
exports.userRiskScoreSeverityFilterSelector = userRiskScoreSeverityFilterSelector;
const authenticationsSelector = () => (0, _reselect.createSelector)(selectUserPage, users => users.queries[_model.UsersTableType.authentications]);
exports.authenticationsSelector = authenticationsSelector;
const usersAnomaliesJobIdFilterSelector = () => (0, _reselect.createSelector)(selectUsersAndDetailsPage, users => {
  var _users$queries$UsersT;
  return (_users$queries$UsersT = users === null || users === void 0 ? void 0 : users.queries[_model.UsersTableType.anomalies].jobIdSelection) !== null && _users$queries$UsersT !== void 0 ? _users$queries$UsersT : [];
});
exports.usersAnomaliesJobIdFilterSelector = usersAnomaliesJobIdFilterSelector;
const usersAnomaliesIntervalSelector = () => (0, _reselect.createSelector)(selectUsersAndDetailsPage, users => {
  var _users$queries$UsersT2;
  return (_users$queries$UsersT2 = users === null || users === void 0 ? void 0 : users.queries[_model.UsersTableType.anomalies].intervalSelection) !== null && _users$queries$UsersT2 !== void 0 ? _users$queries$UsersT2 : 'auto';
});
exports.usersAnomaliesIntervalSelector = usersAnomaliesIntervalSelector;
const selectUserAssetTableById = (state, tableId) => state.users.flyout.queries[tableId];
exports.selectUserAssetTableById = selectUserAssetTableById;
const selectUserAssetTables = state => state.users.flyout.queries;
exports.selectUserAssetTables = selectUserAssetTables;