"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDirectionIcon = exports.UNKNOWN = exports.OUTGOING = exports.OUTBOUND = exports.LISTENING = exports.INTERNAL = exports.INCOMING = exports.INBOUND = exports.EXTERNAL = exports.DirectionBadge = exports.DEFAULT_ICON = void 0;
var _react = _interopRequireDefault(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _draggables = require("../../../../common/components/draggables");
var _field_names = require("../source_destination/field_names");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/direction/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INBOUND = exports.INBOUND = 'inbound';
const OUTBOUND = exports.OUTBOUND = 'outbound';
const EXTERNAL = exports.EXTERNAL = 'external';
const INTERNAL = exports.INTERNAL = 'internal';
const INCOMING = exports.INCOMING = 'incoming';
const OUTGOING = exports.OUTGOING = 'outgoing';
const LISTENING = exports.LISTENING = 'listening';
const UNKNOWN = exports.UNKNOWN = 'unknown';
const DEFAULT_ICON = exports.DEFAULT_ICON = 'question';

/** Returns an icon representing the value of `network.direction` */
const getDirectionIcon = networkDirection => {
  if (networkDirection == null) {
    return DEFAULT_ICON;
  }
  const direction = `${networkDirection}`.toLowerCase();
  switch (direction) {
    case _search_strategy.NetworkDirectionEcs.outbound:
    case _search_strategy.NetworkDirectionEcs.outgoing:
      return 'arrowUp';
    case _search_strategy.NetworkDirectionEcs.inbound:
    case _search_strategy.NetworkDirectionEcs.incoming:
    case _search_strategy.NetworkDirectionEcs.listening:
      return 'arrowDown';
    case _search_strategy.NetworkDirectionEcs.external:
      return 'globe';
    case _search_strategy.NetworkDirectionEcs.internal:
      return 'bullseye';
    case _search_strategy.NetworkDirectionEcs.unknown:
    default:
      return DEFAULT_ICON;
  }
};

/**
 * Renders a badge containing the value of `network.direction`
 */
exports.getDirectionIcon = getDirectionIcon;
const DirectionBadge = exports.DirectionBadge = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  direction,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  field: _field_names.NETWORK_DIRECTION_FIELD_NAME,
  iconType: getDirectionIcon(direction),
  value: direction,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 3
  }
}));
DirectionBadge.displayName = 'DirectionBadge';