"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WHOIS = exports.VIEW_WHOIS = exports.VIEW_VIRUS_TOTAL = exports.VIEW_TALOS_INTELLIGENCE = exports.REPUTATION = exports.MAX_ANOMALY_SCORE_BY_JOB = exports.LOCATION = exports.LAST_SEEN = exports.INSPECT_TITLE = exports.HOST_NAME = exports.HOST_ID = exports.FIRST_SEEN = exports.AUTONOMOUS_SYSTEM = exports.AS_SOURCE = exports.AS_DESTINATION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCATION = exports.LOCATION = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.locationTitle', {
  defaultMessage: 'Location'
});
const AUTONOMOUS_SYSTEM = exports.AUTONOMOUS_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.autonomousSystemTitle', {
  defaultMessage: 'Autonomous system'
});
const MAX_ANOMALY_SCORE_BY_JOB = exports.MAX_ANOMALY_SCORE_BY_JOB = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.maxAnomalyScoreByJobTitle', {
  defaultMessage: 'Max anomaly score by job'
});
const FIRST_SEEN = exports.FIRST_SEEN = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.firstSeenTitle', {
  defaultMessage: 'First seen'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
const HOST_ID = exports.HOST_ID = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.hostIdTitle', {
  defaultMessage: 'Host ID'
});
const HOST_NAME = exports.HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.hostNameTitle', {
  defaultMessage: 'Host name'
});
const WHOIS = exports.WHOIS = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.whoIsTitle', {
  defaultMessage: 'WhoIs'
});
const VIEW_WHOIS = exports.VIEW_WHOIS = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.viewWhoisTitle', {
  defaultMessage: 'iana.org'
});
const REPUTATION = exports.REPUTATION = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.ipReputationTitle', {
  defaultMessage: 'Reputation'
});
const VIEW_VIRUS_TOTAL = exports.VIEW_VIRUS_TOTAL = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.viewVirusTotalTitle.', {
  defaultMessage: 'virustotal.com'
});
const VIEW_TALOS_INTELLIGENCE = exports.VIEW_TALOS_INTELLIGENCE = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.viewTalosIntelligenceTitle', {
  defaultMessage: 'talosIntelligence.com'
});
const AS_SOURCE = exports.AS_SOURCE = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.asSourceDropDownOptionLabel', {
  defaultMessage: 'As Source'
});
const AS_DESTINATION = exports.AS_DESTINATION = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.asDestinationDropDownOptionLabel', {
  defaultMessage: 'As Destination'
});
const INSPECT_TITLE = exports.INSPECT_TITLE = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.inspectTitle', {
  defaultMessage: 'IP overview'
});