"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListsDetailViewComponent = exports.ListsDetailView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _constants = require("../../../../common/constants");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _reference_error_modal = require("../../../common/components/reference_error_modal");
var _missing_privileges = require("../../../common/components/missing_privileges");
var _ = require("../../../app/404");
var _auto_download = require("../../../common/components/auto_download/auto_download");
var _components = require("../../components");
var _hooks = require("../../hooks");
var i18n = _interopRequireWildcard(require("../../translations"));
var _expired_exceptions_list_items_modal = require("../../components/expired_exceptions_list_items_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/pages/list_detail_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ListsDetailViewComponent = () => {
  const {
    detailName: exceptionListId
  } = (0, _reactRouterDom.useParams)();
  const {
    isLoading,
    invalidListId,
    isReadOnly,
    list,
    canUserEditList,
    listId,
    linkedRules,
    exportedList,
    handleOnDownload,
    viewerStatus,
    listName,
    listDescription,
    showManageRulesFlyout,
    headerBackOptions,
    showReferenceErrorModal,
    referenceModalState,
    showManageButtonLoader,
    refreshExceptions,
    disableManageButton,
    onEditListDetails,
    onDuplicateList,
    onExportList,
    onManageRules,
    onSaveManageRules,
    onCancelManageRules,
    onRuleSelectionChange,
    handleDelete,
    handleCloseReferenceErrorModal,
    handleReferenceDelete
  } = (0, _hooks.useListDetailsView)(exceptionListId);
  const [showIncludeExpiredExceptionItemsModal, setShowIncludeExpiredExceptionItemsModal] = (0, _react.useState)(null);
  const onModalClose = (0, _react.useCallback)(() => setShowIncludeExpiredExceptionItemsModal(null), [setShowIncludeExpiredExceptionItemsModal]);
  const onModalOpen = (0, _react.useCallback)(actionType => {
    setShowIncludeExpiredExceptionItemsModal(actionType);
  }, [setShowIncludeExpiredExceptionItemsModal]);
  const handleExportList = (0, _react.useCallback)(() => {
    if ((list === null || list === void 0 ? void 0 : list.type) === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
      onExportList(true);
    } else {
      onModalOpen('export');
    }
  }, [onModalOpen, list, onExportList]);
  const handleDuplicateList = (0, _react.useCallback)(() => {
    onModalOpen('duplicate');
  }, [onModalOpen]);
  const detailsViewContent = (0, _react.useMemo)(() => {
    if (viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.ERROR) return /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.EmptyViewerState, {
      isReadOnly: isReadOnly,
      viewerStatus: viewerStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 14
      }
    });
    if (isLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 4,
      "data-test-subj": "loading",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 27
      }
    });
    if (invalidListId || !listName || !list) return /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 53
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.ExceptionListHeader, {
      name: listName,
      description: listDescription,
      listId: listId,
      linkedRules: linkedRules,
      isReadonly: isReadOnly,
      canUserEditList: canUserEditList,
      backOptions: headerBackOptions,
      securityLinkAnchorComponent: _components.LinkToRuleDetails,
      onEditListDetails: onEditListDetails,
      onExportList: handleExportList,
      onDeleteList: handleDelete,
      onManageRules: onManageRules,
      onDuplicateList: handleDuplicateList,
      dataTestSubj: "exceptionListManagement",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_auto_download.AutoDownload, {
      blob: exportedList,
      name: `${listId}.ndjson`,
      onDownload: handleOnDownload,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.ListWithSearch, {
      list: list,
      refreshExceptions: refreshExceptions,
      isReadOnly: isReadOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_reference_error_modal.ReferenceErrorModal, {
      cancelText: i18n.REFERENCE_MODAL_CANCEL_BUTTON,
      confirmText: i18n.REFERENCE_MODAL_CONFIRM_BUTTON,
      contentText: referenceModalState.contentText,
      onCancel: handleCloseReferenceErrorModal,
      onClose: handleCloseReferenceErrorModal,
      onConfirm: handleReferenceDelete,
      references: referenceModalState.rulesReferences,
      showModal: showReferenceErrorModal,
      titleText: i18n.REFERENCE_MODAL_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }), showManageRulesFlyout ? /*#__PURE__*/_react.default.createElement(_components.ManageRules, {
      linkedRules: linkedRules,
      showButtonLoader: showManageButtonLoader,
      saveIsDisabled: disableManageButton,
      onSave: onSaveManageRules,
      onCancel: onCancelManageRules,
      onRuleSelectionChange: onRuleSelectionChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }) : null, showIncludeExpiredExceptionItemsModal && /*#__PURE__*/_react.default.createElement(_expired_exceptions_list_items_modal.IncludeExpiredExceptionsModal, {
      onModalConfirm: showIncludeExpiredExceptionItemsModal === 'export' ? onExportList : onDuplicateList,
      handleCloseModal: onModalClose,
      action: showIncludeExpiredExceptionItemsModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }));
  }, [viewerStatus, isReadOnly, isLoading, invalidListId, listName, list, listDescription, listId, linkedRules, canUserEditList, headerBackOptions, onEditListDetails, handleExportList, handleDelete, onManageRules, handleDuplicateList, exportedList, handleOnDownload, refreshExceptions, referenceModalState.contentText, referenceModalState.rulesReferences, handleCloseReferenceErrorModal, handleReferenceDelete, showReferenceErrorModal, showManageRulesFlyout, showManageButtonLoader, disableManageButton, onSaveManageRules, onCancelManageRules, onRuleSelectionChange, showIncludeExpiredExceptionItemsModal, onExportList, onDuplicateList, onModalClose]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.exceptions,
    state: {
      listName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), detailsViewContent);
};
exports.ListsDetailViewComponent = ListsDetailViewComponent;
ListsDetailViewComponent.displayName = 'ListsDetailViewComponent';
const ListsDetailView = exports.ListsDetailView = /*#__PURE__*/_react.default.memo(ListsDetailViewComponent);
ListsDetailView.displayName = 'ListsDetailView';