"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scoreFormatter = exports.RiskScoreOverTime = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../common/components/header_section");
var _inspect = require("../../../common/components/inspect");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _risk_score_over_time_area = require("../../lens_attributes/risk_score_over_time_area");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_score_over_time/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CHART_HEIGHT = 180;
const scoreFormatter = d => Math.round(d).toString();
exports.scoreFormatter = scoreFormatter;
const RiskScoreOverTimeComponent = /*#__PURE__*/_react.default.memo(({
  from,
  to,
  queryId,
  riskEntity,
  title,
  toggleStatus,
  toggleQuery
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "RiskScoreOverTime",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: title,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, spaceId && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    timerange: timerange,
    getLensAttributes: _risk_score_over_time_area.getRiskScoreOverTimeAreaAttributes,
    stackByField: riskEntity,
    id: `${queryId}-embeddable`,
    height: CHART_HEIGHT,
    extraOptions: {
      spaceId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 19
    }
  })))));
});
const RiskScoreOverTime = exports.RiskScoreOverTime = /*#__PURE__*/_react.default.memo(RiskScoreOverTimeComponent); // This is needed to male React.memo work with generic
RiskScoreOverTimeComponent.displayName = 'RiskScoreOverTime';