"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPrivilegedUserIndices = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../../../api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchPrivilegedUserIndices = query => {
  const {
    searchPrivMonIndices
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(['POST', 'SEARCH_PRIVILEGED_USER_MONITORING_INDICES', query], ({
    signal
  }) => searchPrivMonIndices({
    signal,
    query
  }), {
    keepPreviousData: true,
    cacheTime: 0,
    // Do not cache the data because it is used by an autocomplete query
    refetchOnWindowFocus: false
  });
};
exports.useFetchPrivilegedUserIndices = useFetchPrivilegedUserIndices;